/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.lib.license.js;

import com.enonic.lib.license.LicenseDetails;
import com.enonic.lib.license.LicenseManager;
import com.enonic.lib.license.PrivateKey;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

public final class GenerateLicense
implements ScriptBean {
    private LicenseManager licenseManager;
    private String issuedBy;
    private String issuedTo;
    private Instant issueTime;
    private Instant expiryTime;
    private Map<String, String> properties;
    private String privateKey;

    public String generate() {
        PrivateKey privateKey = PrivateKey.from(this.privateKey);
        if (privateKey == null) {
            throw new IllegalArgumentException("Invalid private key");
        }
        LicenseDetails licDetails = LicenseDetails.create().issuedBy(this.issuedBy).issuedTo(this.issuedTo).expiryTime(this.expiryTime).issueTime(this.issueTime).properties(this.properties).build();
        return this.licenseManager.generateLicense(privateKey, licDetails);
    }

    public void setIssuedBy(String issuedBy) {
        this.issuedBy = issuedBy;
    }

    public void setIssuedTo(String issuedTo) {
        this.issuedTo = issuedTo;
    }

    public void setIssueTime(String issueTime) {
        this.issueTime = issueTime != null ? Instant.parse(issueTime) : null;
    }

    public void setExpiryTime(String expiryTime) {
        this.expiryTime = expiryTime != null ? Instant.parse(expiryTime) : null;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = this.filterMap(properties);
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    private Map<String, String> filterMap(Map<String, Object> values) {
        if (values == null) {
            return null;
        }
        HashMap<String, String> filtered = new HashMap<String, String>();
        values.forEach((k, v) -> {
            if (v != null) {
                filtered.put((String)k, v.toString());
            }
        });
        return filtered;
    }

    public void initialize(BeanContext context) {
        this.licenseManager = (LicenseManager)context.getService(LicenseManager.class).get();
    }
}

