/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.lib.license.js;

import com.enonic.lib.license.LicenseManager;
import com.enonic.lib.license.LicenseManagerImpl;
import com.enonic.lib.license.PublicKey;
import com.enonic.xp.branch.Branch;
import com.enonic.xp.context.Context;
import com.enonic.xp.context.ContextAccessor;
import com.enonic.xp.context.ContextBuilder;
import com.enonic.xp.node.NodePath;
import com.enonic.xp.node.NodeService;
import com.enonic.xp.repository.RepositoryService;
import com.enonic.xp.resource.Resource;
import com.enonic.xp.resource.ResourceKey;
import com.enonic.xp.resource.ResourceService;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;
import com.enonic.xp.security.PrincipalKey;
import com.enonic.xp.security.RoleKeys;
import com.enonic.xp.security.User;
import com.enonic.xp.security.auth.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InstallLicense
implements ScriptBean {
    private static final Logger LOG = LoggerFactory.getLogger(InstallLicense.class);
    private LicenseManager licenseManager;
    private RepositoryService repositoryService;
    private NodeService nodeService;
    private ResourceService resourceService;
    private String publicKey;
    private String license;
    private String appKey;
    private ResourceKey publicKeyResource;

    public boolean install() {
        PublicKey publicKey;
        Resource pubKeyRes;
        if (this.publicKey == null && this.publicKeyResource != null && (pubKeyRes = this.resourceService.getResource(this.publicKeyResource)).exists()) {
            this.publicKey = pubKeyRes.readString();
        }
        if ((publicKey = PublicKey.from(this.publicKey)) == null) {
            throw new IllegalArgumentException("Invalid public key");
        }
        return this.licenseManager.installLicense(this.license, publicKey, this.appKey);
    }

    public void uninstall() {
        Context currentCtx = ContextAccessor.current();
        if (!currentCtx.getAuthInfo().hasRole(RoleKeys.AUTHENTICATED)) {
            LOG.warn("License could not be uninstalled, user not authenticated");
            return;
        }
        Context ctx = ContextBuilder.from((Context)currentCtx).repositoryId(LicenseManagerImpl.REPO_ID).branch(Branch.from((String)"master")).authInfo(AuthenticationInfo.create().principals(new PrincipalKey[]{RoleKeys.ADMIN}).user(User.ANONYMOUS).build()).build();
        ctx.runWith(() -> {
            if (this.repositoryService.isInitialized(LicenseManagerImpl.REPO_ID)) {
                this.deleteLicense();
            }
        });
    }

    private void deleteLicense() {
        NodePath path = NodePath.create((NodePath)LicenseManagerImpl.INSTALLED_LICENSES_PATH, (String)this.appKey).build();
        this.nodeService.deleteByPath(path);
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public void setPublicKeyResource(ResourceKey publicKeyResource) {
        this.publicKeyResource = publicKeyResource;
    }

    public void initialize(BeanContext context) {
        this.licenseManager = (LicenseManager)context.getService(LicenseManager.class).get();
        this.repositoryService = (RepositoryService)context.getService(RepositoryService.class).get();
        this.resourceService = (ResourceService)context.getService(ResourceService.class).get();
        this.nodeService = (NodeService)context.getService(NodeService.class).get();
    }
}

