/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.lib.license.js;

import com.enonic.lib.license.LicenseDetails;
import com.enonic.lib.license.LicenseManager;
import com.enonic.lib.license.PublicKey;
import com.enonic.lib.license.js.LicenseMapper;
import com.enonic.xp.app.ApplicationKey;
import com.enonic.xp.resource.Resource;
import com.enonic.xp.resource.ResourceKey;
import com.enonic.xp.resource.ResourceService;
import com.enonic.xp.script.bean.BeanContext;
import com.enonic.xp.script.bean.ScriptBean;

public final class ValidateLicense
implements ScriptBean {
    private LicenseManager licenseManager;
    private ResourceService resourceService;
    private String publicKey;
    private String license;
    private String app;
    private ResourceKey publicKeyResource;

    public LicenseMapper validate() {
        LicenseDetails licDetails;
        PublicKey publicKey;
        Resource pubKeyRes;
        LicenseDetails licDetails2;
        if (this.app != null && this.license == null && (licDetails2 = this.licenseManager.validateLicense(this.app)) != null) {
            return new LicenseMapper(licDetails2);
        }
        if (this.license == null) {
            return null;
        }
        if (this.publicKey == null && this.publicKeyResource != null && (pubKeyRes = this.resourceService.getResource(this.publicKeyResource)).exists()) {
            this.publicKey = pubKeyRes.readString();
        }
        if ((publicKey = PublicKey.from(this.publicKey)) == null) {
            return null;
        }
        if (this.app == null) {
            this.app = ApplicationKey.from(this.getClass()).toString();
        }
        return (licDetails = this.licenseManager.validateLicense(publicKey, this.license)) == null ? null : new LicenseMapper(licDetails);
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setPublicKeyResource(ResourceKey publicKeyResource) {
        this.publicKeyResource = publicKeyResource;
    }

    public void initialize(BeanContext context) {
        this.licenseManager = (LicenseManager)context.getService(LicenseManager.class).get();
        this.resourceService = (ResourceService)context.getService(ResourceService.class).get();
    }
}

