/*
 * Decompiled with CFR 0.152.
 */
package com.enonic.lib.mustache;

import com.enonic.xp.resource.Resource;
import com.enonic.xp.resource.ResourceKey;
import com.enonic.xp.resource.ResourceProblemException;
import com.enonic.xp.resource.ResourceService;
import com.enonic.xp.script.ScriptValue;
import com.enonic.xp.trace.Trace;
import com.enonic.xp.trace.Tracer;
import com.google.common.collect.Maps;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.MustacheException;
import com.samskivert.mustache.Template;
import java.util.HashMap;

public final class MustacheProcessor {
    private final Mustache.Compiler compiler;
    private ResourceKey view;
    private ScriptValue model;
    private ResourceService resourceService;

    public MustacheProcessor(Mustache.Compiler compiler) {
        this.compiler = compiler;
    }

    public void setView(ResourceKey view) {
        this.view = view;
    }

    public void setModel(ScriptValue model) {
        this.model = model;
    }

    public String process() {
        Trace trace = Tracer.newTrace((String)"mustache.render");
        if (trace == null) {
            return this.execute();
        }
        return (String)Tracer.trace((Trace)trace, () -> {
            trace.put((Object)"path", (Object)this.view.getPath());
            trace.put((Object)"app", (Object)this.view.getApplicationKey().toString());
            return this.execute();
        });
    }

    public String execute() {
        try {
            return this.doExecute();
        }
        catch (RuntimeException e) {
            throw this.handleError(e);
        }
    }

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    private String doExecute() {
        Resource resource = this.resourceService.getResource(this.view);
        Template template = this.compiler.compile(resource.readString());
        HashMap map = this.model != null ? this.model.getMap() : Maps.newHashMap();
        return template.execute((Object)map);
    }

    private RuntimeException handleError(RuntimeException e) {
        if (e instanceof MustacheException.Context) {
            return this.handleError((MustacheException.Context)e);
        }
        return e;
    }

    private RuntimeException handleError(MustacheException.Context e) {
        return ResourceProblemException.create().lineNumber(e.lineNo).resource(this.view).cause((Throwable)e).message(e.getMessage(), new Object[0]).build();
    }
}

