/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.akka.extension.quartz;

import com.typesafe.akka.extension.quartz.QuartzCronSchedule;
import com.typesafe.akka.extension.quartz.QuartzSchedule;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.io.Serializable;
import java.text.ParseException;
import java.util.TimeZone;
import org.quartz.CronExpression;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Exception;
import scala.util.control.Exception$;

public final class QuartzSchedules$ {
    public static QuartzSchedules$ MODULE$;
    private final Exception.Catch<Nothing$> catchMissing;
    private final Exception.Catch<Nothing$> catchWrongType;
    private final Exception.Catch<Nothing$> catchParseErr;

    static {
        new QuartzSchedules$();
    }

    public Exception.Catch<Nothing$> catchMissing() {
        return this.catchMissing;
    }

    public Exception.Catch<Nothing$> catchWrongType() {
        return this.catchWrongType;
    }

    public Exception.Catch<Nothing$> catchParseErr() {
        return this.catchParseErr;
    }

    public Map<String, QuartzSchedule> apply(Config config, TimeZone defaultTimezone) {
        return (Map)this.catchMissing().opt((Function0 & Serializable & scala.Serializable)() -> (Map)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)config.getConfig("schedules").root()).asScala()).toMap(Predef$.MODULE$.$conforms()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            String key = (String)tuple2._1();
            ConfigValue value = (ConfigValue)tuple2._2();
            if (!(value instanceof ConfigObject)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            ConfigObject configObject = (ConfigObject)value;
            return Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)MODULE$.parseSchedule(key, configObject.toConfig(), defaultTimezone))));
        }, Map$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Map$.MODULE$.empty());
    }

    public QuartzSchedule parseSchedule(String name, Config config, TimeZone defaultTimezone) {
        TimeZone timezone = (TimeZone)this.catchMissing().opt((Function0 & Serializable & scala.Serializable)() -> TimeZone.getTimeZone(config.getString("timezone"))).getOrElse((Function0 & Serializable & scala.Serializable)() -> defaultTimezone);
        Option calendar = (Option)this.catchMissing().opt((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)config.getString("calendar"))).getOrElse((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
        Option desc = this.catchMissing().opt((Function0 & Serializable & scala.Serializable)() -> config.getString("description"));
        return this.parseCronSchedule(name, (Option<String>)desc, config, timezone, (Option<String>)calendar);
    }

    public QuartzCronSchedule parseCronSchedule(String name, Option<String> desc, Config config, TimeZone tz, Option<String> calendar) {
        CronExpression cronExpression;
        Either either = this.catchMissing().or(this.catchWrongType()).either((Function0 & Serializable & scala.Serializable)() -> config.getString("expression"));
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.value();
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'expression' for Cron Schedule '%s'. You must provide a valid Quartz CronExpression.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
        }
        if (either instanceof Right) {
            CronExpression expr;
            Right right = (Right)either;
            String str = (String)right.value();
            Either either2 = this.catchParseErr().either((Function0 & Serializable & scala.Serializable)() -> new CronExpression(str));
            if (either2 instanceof Left) {
                Left left = (Left)either2;
                Throwable t = (Throwable)left.value();
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid 'expression' for Cron Schedule '%s'. Failed to validate CronExpression.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
            }
            if (!(either2 instanceof Right)) {
                throw new MatchError((Object)either2);
            }
            Right right2 = (Right)either2;
            cronExpression = expr = (CronExpression)right2.value();
        } else {
            throw new MatchError((Object)either);
        }
        CronExpression cronExpression2 = cronExpression;
        CronExpression expression = cronExpression2;
        return new QuartzCronSchedule(name, desc, expression, tz, calendar);
    }

    private QuartzSchedules$() {
        MODULE$ = this;
        this.catchMissing = Exception$.MODULE$.catching((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ConfigException.Missing.class}));
        this.catchWrongType = Exception$.MODULE$.catching((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ConfigException.WrongType.class}));
        this.catchParseErr = Exception$.MODULE$.catching((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ParseException.class}));
    }
}

