/*
 * Decompiled with CFR 0.152.
 */
package com.enragedginger.stephenerialization.destephenerialize;

import com.enragedginger.stephenerialization.StephenerializationException;
import com.enragedginger.stephenerialization.destephenerialize.Destephenerializer;
import com.enragedginger.stephenerialization.fields.SimpleStephenerializableFieldFactory;
import com.enragedginger.stephenerialization.fields.StephenerializableField;
import com.enragedginger.stephenerialization.fields.StephenerializableFieldFactory;
import com.enragedginger.stephenerialization.fields.StephenerializableType;
import com.enragedginger.stephenerialization.streamer.DestephenerializationStream;
import java.lang.reflect.Field;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDestephenerializer
implements Destephenerializer {
    private static final String ERROR_MSG = "An error occurred while performing destephenerialization.";
    private StephenerializableFieldFactory fieldFactory;

    @Override
    public void destephenerialize(Object object, DestephenerializationStream streamer, Class<?> clazz) {
        try {
            int version = streamer.readInt();
            Set<StephenerializableField> fields = this.getFieldFactory().generateFields(clazz, version);
            for (StephenerializableField field : fields) {
                this.readField(object, field.getField(), streamer);
            }
        }
        catch (Exception e) {
            throw new StephenerializationException(ERROR_MSG, e);
        }
    }

    private void readField(Object object, Field field, DestephenerializationStream streamer) throws IllegalArgumentException, IllegalAccessException {
        field.setAccessible(true);
        StephenerializableType type = StephenerializableType.lookup(field.getType());
        switch (type) {
            case BYTE: {
                field.setByte(object, streamer.readByte());
                break;
            }
            case SHORT: {
                field.setShort(object, streamer.readShort());
                break;
            }
            case INT: {
                field.setInt(object, streamer.readInt());
                break;
            }
            case LONG: {
                field.setLong(object, streamer.readLong());
                break;
            }
            case FLOAT: {
                field.setFloat(object, streamer.readFloat());
                break;
            }
            case DOUBLE: {
                field.setDouble(object, streamer.readDouble());
                break;
            }
            case BOOLEAN: {
                field.setBoolean(object, streamer.readBoolean());
                break;
            }
            case CHAR: {
                field.setChar(object, streamer.readChar());
                break;
            }
            case OBJECT: {
                field.set(object, streamer.readObject());
                break;
            }
            default: {
                throw new StephenerializationException("Unsupported destephenerialization type: " + (Object)((Object)type));
            }
        }
    }

    public void setFieldFactory(StephenerializableFieldFactory fieldFactory) {
        this.fieldFactory = fieldFactory;
    }

    public StephenerializableFieldFactory getFieldFactory() {
        if (this.fieldFactory == null) {
            this.fieldFactory = new SimpleStephenerializableFieldFactory();
        }
        return this.fieldFactory;
    }
}

