/*
 * Decompiled with CFR 0.152.
 */
package com.enragedginger.stephenerialization.fields;

import com.enragedginger.stephenerialization.annotations.Stephenerializable;
import com.enragedginger.stephenerialization.annotations.Stephenerialize;
import com.enragedginger.stephenerialization.fields.StephenerializableField;
import com.enragedginger.stephenerialization.fields.StephenerializableFieldFactory;
import com.enragedginger.stephenerialization.fields.StephenerializableFieldSetKey;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleStephenerializableFieldFactory
implements StephenerializableFieldFactory {
    private Map<StephenerializableFieldSetKey, Set<StephenerializableField>> fieldSetCache = new HashMap<StephenerializableFieldSetKey, Set<StephenerializableField>>();

    @Override
    public Set<StephenerializableField> generateFields(Class<?> clazz, int maxVersion) {
        TreeSet<StephenerializableField> fields;
        StephenerializableFieldSetKey fieldSetKey = this.createKey(clazz, maxVersion);
        if (!this.fieldSetCache.containsKey(fieldSetKey)) {
            fields = new TreeSet<StephenerializableField>();
            fields.addAll(this.generateLocalFields(clazz, maxVersion));
            this.fieldSetCache.put(fieldSetKey, fields);
        } else {
            fields = this.fieldSetCache.get(fieldSetKey);
        }
        return fields;
    }

    private StephenerializableFieldSetKey createKey(Class<?> clazz, int maxVersion) {
        StephenerializableFieldSetKey key = new StephenerializableFieldSetKey();
        key.setClazz(clazz);
        key.setMaxVersion(maxVersion);
        return key;
    }

    private Set<StephenerializableField> generateLocalFields(Class<?> clazz, int maxVersion) {
        TreeSet<StephenerializableField> fields = new TreeSet<StephenerializableField>();
        Stephenerializable annotation = clazz.getAnnotation(Stephenerializable.class);
        if (annotation != null) {
            for (Field field : clazz.getDeclaredFields()) {
                Stephenerialize stephenerialize = field.getAnnotation(Stephenerialize.class);
                if (stephenerialize == null || stephenerialize.minVersion() > maxVersion) continue;
                StephenerializableField stephenField = new StephenerializableField();
                stephenField.setField(field);
                stephenField.setVersion(stephenerialize.minVersion());
                stephenField.setOrder(stephenerialize.priority());
                fields.add(stephenField);
            }
        }
        return fields;
    }
}

