/*
 * Decompiled with CFR 0.152.
 */
package com.enragedginger.stephenerialization.preprocessing;

import java.io.IOException;
import java.io.Writer;

public class PreprocessingWriter {
    private Writer writer;
    private int indentation;
    private static final String TAB = "    ";

    public PreprocessingWriter(Writer writer) {
        this.writer = writer;
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void setIndentation(int indentation) {
        this.indentation = Math.max(0, indentation);
    }

    public void indent() {
        ++this.indentation;
    }

    public void deindent() {
        this.setIndentation(this.indentation - 1);
    }

    public void resetIndentation() {
        this.indentation = 0;
    }

    public void writeLine(String line) throws IOException {
        StringBuffer buffy = new StringBuffer();
        for (int i = 0; i < this.indentation; ++i) {
            buffy.append(TAB);
        }
        buffy.append(line);
        buffy.append("\n");
        this.writer.write(buffy.toString());
    }

    public void close() throws IOException {
        this.writer.close();
    }
}

