/*
 * Decompiled with CFR 0.152.
 */
package com.enragedginger.stephenerialization.preprocessing;

import com.enragedginger.stephenerialization.annotations.Stephenerializable;
import com.enragedginger.stephenerialization.preprocessing.PreprocessingWriter;
import com.enragedginger.stephenerialization.preprocessing.StephenerializationPreprocessorField;
import com.enragedginger.stephenerialization.preprocessing.StephenerializationPreprocessorFieldGenerator;
import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"com.enragedginger.stephenerialization.annotations.Stephenerializable"})
public class StephenerializableAnnotationProcessor
extends AbstractProcessor {
    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Messager messager = this.processingEnv.getMessager();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                try {
                    this.processAnnotation(element, messager);
                }
                catch (Exception e) {
                    throw new RuntimeException("An error occurred while preprocessing Stephenerialization annotations.", e);
                }
            }
        }
        return true;
    }

    private void processAnnotation(Element element, Messager messager) throws IOException, ClassNotFoundException {
        Stephenerializable stephenerializable = element.getAnnotation(Stephenerializable.class);
        String className = element.toString();
        String simpleName = element.getSimpleName().toString();
        String generatedClassName = className + "Stephenerializer";
        String simpleGeneratedClassName = simpleName + "Stephenerializer";
        Filer filer = this.processingEnv.getFiler();
        JavaFileObject sourceFile = filer.createSourceFile(generatedClassName, new Element[0]);
        StephenerializationPreprocessorFieldGenerator generator = new StephenerializationPreprocessorFieldGenerator();
        Set<StephenerializationPreprocessorField> fields = generator.generateFields(element);
        PreprocessingWriter w = new PreprocessingWriter(sourceFile.openWriter());
        this.writePackageImportsAndClass(w, element, simpleGeneratedClassName);
        w.indent();
        this.writeWriteMethod(w, className, fields, stephenerializable);
        w.writeLine("");
        this.writeReadMethod(w, className, fields);
        w.deindent();
        w.writeLine("}");
        w.close();
        messager.printMessage(Diagnostic.Kind.NOTE, "Generated stephenerializer: " + generatedClassName);
    }

    private void writePackageImportsAndClass(PreprocessingWriter w, Element element, String simpleGeneratedClassName) throws IOException {
        PackageElement p = this.processingEnv.getElementUtils().getPackageOf(element);
        w.writeLine("package " + p.getQualifiedName().toString() + ";\n");
        w.writeLine("import com.enragedginger.stephenerialization.StephenerializationException;");
        w.writeLine("import java.io.ObjectInputStream;");
        w.writeLine("import java.io.ObjectOutputStream;\n");
        w.writeLine("class " + simpleGeneratedClassName + " {");
    }

    private void writeWriteMethod(PreprocessingWriter w, String className, Set<StephenerializationPreprocessorField> fields, Stephenerializable stephenerializable) throws IOException {
        w.writeLine("public static void stephenerialize(" + className + " object, ObjectOutputStream stream) {");
        w.indent();
        if (fields != null && !fields.isEmpty()) {
            w.writeLine("try {");
            w.indent();
            w.writeLine("stream.writeInt(" + stephenerializable.version() + ");");
            for (StephenerializationPreprocessorField field : fields) {
                w.writeLine("stream." + field.getObjectOutputStreamMethod() + "(object." + field.getGetterName() + "());");
            }
            w.deindent();
            w.writeLine("} catch (Exception e) {");
            w.indent();
            w.writeLine("throw new StephenerializationException(\"An error occurred during Stephenerialization.\", e);");
            w.deindent();
            w.writeLine("}");
        }
        w.deindent();
        w.writeLine("}");
    }

    private void writeReadMethod(PreprocessingWriter w, String className, Set<StephenerializationPreprocessorField> fields) throws IOException {
        w.writeLine("public static void destephenerialize(" + className + " object, ObjectInputStream stream) {");
        w.indent();
        if (fields != null && !fields.isEmpty()) {
            w.writeLine("try {");
            w.indent();
            w.writeLine("final int version = stream.readInt();");
            Integer previousVersion = null;
            for (StephenerializationPreprocessorField field : fields) {
                if (previousVersion == null) {
                    previousVersion = field.getVersion();
                    w.writeLine("if (version >= " + field.getVersion() + ") {");
                }
                if (previousVersion.intValue() != field.getVersion()) {
                    w.writeLine("}");
                    w.writeLine("if (version >= " + field.getVersion() + ") {");
                }
                w.indent();
                StringBuffer buffy = new StringBuffer();
                buffy.append("object." + field.getSetterName() + "(");
                if (!field.isPrimitive()) {
                    buffy.append("(" + field.getFieldTypeName() + ") ");
                }
                buffy.append("stream." + field.getObjectInputStreamMethod() + "());");
                w.writeLine(buffy.toString());
                w.deindent();
                previousVersion = field.getVersion();
            }
            w.writeLine("}");
            w.deindent();
            w.writeLine("} catch (Exception e) {");
            w.indent();
            w.writeLine("throw new StephenerializationException(\"An error occurred during Destephenerialization.\", e);");
            w.deindent();
            w.writeLine("}");
        }
        w.deindent();
        w.writeLine("}");
    }
}

