/*
 * Decompiled with CFR 0.152.
 */
package com.enragedginger.stephenerialization.preprocessing;

import com.enragedginger.stephenerialization.annotations.Stephenerialize;
import com.enragedginger.stephenerialization.preprocessing.StephenerializationPreprocessorField;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StephenerializationPreprocessorFieldGenerator {
    public Set<StephenerializationPreprocessorField> generateFields(Element classElement) {
        TreeSet<StephenerializationPreprocessorField> instanceFields = new TreeSet<StephenerializationPreprocessorField>();
        for (VariableElement instanceField : ElementFilter.fieldsIn(classElement.getEnclosedElements())) {
            if (instanceField.getModifiers().contains((Object)Modifier.STATIC) || instanceField.getAnnotation(Stephenerialize.class) == null) continue;
            StephenerializationPreprocessorField preprocessorField = this.buildPreprocessorField(instanceField);
            instanceFields.add(preprocessorField);
        }
        return instanceFields;
    }

    public StephenerializationPreprocessorField buildPreprocessorField(VariableElement variableElement) {
        StephenerializationPreprocessorField field = new StephenerializationPreprocessorField();
        Stephenerialize stephenerialize = variableElement.getAnnotation(Stephenerialize.class);
        field.setOrder(stephenerialize.priority());
        field.setVersion(stephenerialize.minVersion());
        String typeName = variableElement.asType().toString();
        boolean isPrimitive = variableElement.asType().getKind().isPrimitive();
        field.setFieldTypeName(typeName);
        field.setPrimitive(isPrimitive);
        field.setObjectInputStreamMethod(this.buildInputObjectStreamMethodName(isPrimitive, typeName));
        field.setObjectOutputStreamMethod(this.buildObjectOutputStreamMethodName(isPrimitive, typeName));
        String fieldName = variableElement.getSimpleName().toString();
        field.setFieldName(fieldName);
        String prefix = variableElement.asType().toString().equals("boolean") ? "is" : "get";
        String upperCasedFieldName = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        field.setGetterName(prefix + upperCasedFieldName);
        field.setSetterName("set" + upperCasedFieldName);
        return field;
    }

    private String buildObjectOutputStreamMethodName(boolean isPrimitive, String typeName) {
        if (isPrimitive) {
            if ("int".equals(typeName)) {
                return "writeInt";
            }
            if ("long".equals(typeName)) {
                return "writeLong";
            }
            if ("short".equals(typeName)) {
                return "writeShort";
            }
            if ("byte".equals(typeName)) {
                return "writeByte";
            }
            if ("float".equals(typeName)) {
                return "writeFloat";
            }
            if ("double".equals(typeName)) {
                return "writeDouble";
            }
            if ("boolean".equals(typeName)) {
                return "writeBoolean";
            }
            if ("char".equals(typeName)) {
                return "writeChar";
            }
            throw new IllegalArgumentException("Type was supposedly primitive but was actually: " + typeName);
        }
        return "writeObject";
    }

    private String buildInputObjectStreamMethodName(boolean isPrimitive, String typeName) {
        if (isPrimitive) {
            if ("int".equals(typeName)) {
                return "readInt";
            }
            if ("long".equals(typeName)) {
                return "readLong";
            }
            if ("short".equals(typeName)) {
                return "readShort";
            }
            if ("byte".equals(typeName)) {
                return "readByte";
            }
            if ("float".equals(typeName)) {
                return "readFloat";
            }
            if ("double".equals(typeName)) {
                return "readDouble";
            }
            if ("boolean".equals(typeName)) {
                return "readBoolean";
            }
            if ("char".equals(typeName)) {
                return "readChar";
            }
            throw new IllegalArgumentException("Type was supposedly primitive but was actually: " + typeName);
        }
        return "readObject";
    }
}

