/*
 * Decompiled with CFR 0.152.
 */
package com.enragedginger.stephenerialization.stephenerialize;

import com.enragedginger.stephenerialization.StephenerializationException;
import com.enragedginger.stephenerialization.annotations.Stephenerializable;
import com.enragedginger.stephenerialization.fields.SimpleStephenerializableFieldFactory;
import com.enragedginger.stephenerialization.fields.StephenerializableField;
import com.enragedginger.stephenerialization.fields.StephenerializableFieldFactory;
import com.enragedginger.stephenerialization.fields.StephenerializableType;
import com.enragedginger.stephenerialization.stephenerialize.Stephenerializer;
import com.enragedginger.stephenerialization.streamer.StephenerializationStream;
import java.lang.reflect.Field;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleStephenerializer
implements Stephenerializer {
    private static final String ERROR_MSG = "An error occurred while performing stepherialization.";
    private StephenerializableFieldFactory fieldFactory;

    @Override
    public void stephenerialize(Object object, StephenerializationStream streamer, Class<?> clazz) {
        Stephenerializable annotation = clazz.getAnnotation(Stephenerializable.class);
        if (annotation == null) {
            throw new StephenerializationException("The class " + clazz.getName() + " cannot be Stephenerialized " + "because it lacks a Stephenerializable annotation.");
        }
        int version = annotation.version();
        Set<StephenerializableField> fields = this.getFieldFactory().generateFields(clazz, version);
        try {
            streamer.writeInt(version);
            for (StephenerializableField field : fields) {
                this.writeField(object, field.getField(), streamer);
            }
        }
        catch (Exception e) {
            throw new StephenerializationException(ERROR_MSG, e);
        }
    }

    private void writeField(Object object, Field field, StephenerializationStream streamer) throws IllegalArgumentException, IllegalAccessException {
        field.setAccessible(true);
        StephenerializableType type = StephenerializableType.lookup(field.getType());
        switch (type) {
            case BYTE: {
                streamer.writeByte(field.getByte(object));
                break;
            }
            case SHORT: {
                streamer.writeShort(field.getShort(object));
                break;
            }
            case INT: {
                streamer.writeInt(field.getInt(object));
                break;
            }
            case LONG: {
                streamer.writeLong(field.getLong(object));
                break;
            }
            case FLOAT: {
                streamer.writeFloat(field.getFloat(object));
                break;
            }
            case DOUBLE: {
                streamer.writeDouble(field.getDouble(object));
                break;
            }
            case BOOLEAN: {
                streamer.writeBoolean(field.getBoolean(object));
                break;
            }
            case CHAR: {
                streamer.writeChar(field.getChar(object));
                break;
            }
            case OBJECT: {
                streamer.writeObject(field.get(object));
                break;
            }
            default: {
                throw new StephenerializationException("Unsupported stephenerialization type: " + (Object)((Object)type));
            }
        }
    }

    public void setFieldFactory(StephenerializableFieldFactory fieldFactory) {
        this.fieldFactory = fieldFactory;
    }

    public StephenerializableFieldFactory getFieldFactory() {
        if (this.fieldFactory == null) {
            this.fieldFactory = new SimpleStephenerializableFieldFactory();
        }
        return this.fieldFactory;
    }
}

