package com.enterprisemath.utils;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * Code generator which generates UUID in the string formats.
 *
 * @author radek.hecl
 *
 */
public class UUIDUniqueCodeGenerator implements UniqueCodeGenerator {

    /**
     * Builder object.
     */
    public static class Builder {

        /**
         * Builds the result object.
         *
         * @return created object
         */
        public UUIDUniqueCodeGenerator build() {
            return new UUIDUniqueCodeGenerator(this);
        }

    }

    /**
     * Object for synchronization.
     */
    private final Object lock = new Object();

    /**
     * Creates new instance.
     *
     * @param builder builder object
     */
    public UUIDUniqueCodeGenerator(Builder builder) {
        guardInvariants();
    }

    /**
     * Guards this object to be consistent. Throws exception if this is not the case.
     */
    private void guardInvariants() {
    }

    @Override
    public String generateUniqueCode(String prefix) {
        synchronized (lock) {
            return UUID.randomUUID().toString();
        }
    }

    @Override
    public Set<String> generateUniqueCodes(String prefix, int number) {
        synchronized (lock) {
            Set<String> res = new HashSet<String>();
            while (res.size() < number) {
                res.add(UUID.randomUUID().toString());
            }
            return res;
        }
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    /**
     * Creates new instance.
     *
     * @return created instance
     */
    public static UUIDUniqueCodeGenerator create() {
        return new UUIDUniqueCodeGenerator.Builder().
                build();
    }
}
