package com.enterprisemath.utils;

import java.util.Set;

/**
 * Provides functionality to unique code generation.
 *
 * @author radek.hecl
 *
 */
public interface UniqueCodeGenerator {

    /**
     * Generates code with high probability this will be the globally unique one.
     *
     * @param prefix prefix of generated code
     * @return generated code
     */
    public String generateUniqueCode(String prefix);

    /**
     * Generates multiple codes with high probability these will be the globally unique ones.
     *
     * @param prefix prefix of all generated codes
     * @param number number of codes to generate, must be greater than 0
     * @return generated codes
     */
    public Set<String> generateUniqueCodes(String prefix, int number);

}
