package com.enterprisemath.utils.engine;

/**
 * Defines functionality of engine. Engine is component for asynchronous task invocation.
 *
 * @author radek.hecl
 */
public interface Engine {

    /**
     * Returns the engine status.
     *
     * @return current engine status
     */
    public EngineStatus getStatus();

    /**
     * Returns task manager of the particular task.
     * If identification code refers to the non existing task, then returns null.
     * If identification code refers to the task which is already done, then result might be task manager or null.
     *
     * @param code task identification code
     * @return task manager or null
     */
    public TaskManager getTaskManager(String code);

    /**
     * Runs task according specified order.
     *
     * @param order order for run
     * @return object for accessing task details and controlling the further execution
     */
    public TaskManager run(TaskRunOrder order);

}
