package com.enterprisemath.utils.messaging;

import java.util.Map;

/**
 * Defines functionality for system message.
 * This is designed for sending messages to the administrator.
 * Supports are standard message and various methods for sending errors.
 *
 * <p>
 * <strong>Note:</strong> Adding functions to this interface will <strong>NOT</strong> be
 * considered as breaking binary compatibility.
 * </p>
 *
 * @author radek.hecl
 *
 */
public interface SystemMessenger {

    /**
     * Sends message.
     *
     * @param message message to send
     */
    public void send(Message message);

    /**
     * Sends error message without exception.
     *
     * @param caption caption of the error
     * @param explanation message with error explanation
     */
    public void sendError(String caption, String explanation);

    /**
     * Sends error message with exception.
     *
     * @param caption caption of the error
     * @param explanation message with error explanation
     * @param e error
     */
    public void sendError(String caption, String explanation, Throwable e);

    /**
     * Sends error message with exception.
     *
     * @param caption caption of the error
     * @param explanation message with error explanation
     * @param exceptionDetails details about exception serialized to the map
     */
    public void sendError(String caption, String explanation, Map<String, String> exceptionDetails);
}
