/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils;

import com.enterprisemath.utils.StringParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public final class CsvUtils {
    private CsvUtils() {
    }

    public static List<List<String>> parse(byte[] data) {
        ByteArrayInputStream bis = null;
        List lines = null;
        try {
            bis = new ByteArrayInputStream(data);
            lines = IOUtils.readLines((InputStream)bis, (String)"utf-8");
            bis.close();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)bis);
        ArrayList<List<String>> res = new ArrayList<List<String>>(lines.size() - 1);
        ArrayList<String> csvLine = new ArrayList<String>();
        boolean escapedCell = false;
        StringBuilder cellBuilder = null;
        for (int l = 0; l < lines.size(); ++l) {
            StringParser parser = new StringParser((String)lines.get(l));
            while (parser.hasNext()) {
                String str;
                if (cellBuilder == null) {
                    String chr = parser.readCharacter();
                    if (chr.equals(",")) {
                        csvLine.add("");
                        continue;
                    }
                    if (chr.equals("\"")) {
                        escapedCell = true;
                        cellBuilder = new StringBuilder();
                        continue;
                    }
                    escapedCell = false;
                    cellBuilder = new StringBuilder();
                    cellBuilder.append(chr);
                    continue;
                }
                if (escapedCell) {
                    str = parser.readTillStop("\"");
                    cellBuilder.append(str);
                    if (!parser.hasNext()) continue;
                    parser.readCharacter();
                    if (parser.hasNext()) {
                        String next = parser.readCharacter();
                        if (next.equals("\"")) {
                            cellBuilder.append("\"");
                            continue;
                        }
                        if (!next.equals(",")) continue;
                        csvLine.add(cellBuilder.toString());
                        cellBuilder = null;
                        continue;
                    }
                    csvLine.add(cellBuilder.toString());
                    cellBuilder = null;
                    continue;
                }
                str = parser.readTillStop(",");
                cellBuilder.append(str);
                csvLine.add(cellBuilder.toString());
                cellBuilder = null;
                if (!parser.hasNext()) continue;
                parser.readCharacter();
            }
            if (cellBuilder == null) {
                res.add(csvLine);
                csvLine = new ArrayList();
                continue;
            }
            cellBuilder.append("\n");
        }
        if (cellBuilder != null) {
            throw new IllegalArgumentException("last cell in file is not closed: line = " + lines.size());
        }
        return res;
    }

    public static byte[] format(List<List<String>> data) {
        StringBuilder res = new StringBuilder();
        for (List<String> line : data) {
            for (int i = 0; i < line.size(); ++i) {
                String cell = StringUtils.defaultString((String)line.get(i));
                cell = cell.replaceAll("\"", "\"\"");
                res.append("\"").append(cell).append("\"");
                if (i == line.size() - 1) {
                    res.append("\n");
                    continue;
                }
                res.append(",");
            }
        }
        return res.toString().getBytes(Charset.forName("utf-8"));
    }
}

