/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils;

import com.enterprisemath.utils.ValidationUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DomainUtils {
    private DomainUtils() {
    }

    public static Date copyDate(Date source) {
        if (source == null) {
            return null;
        }
        return new Date(source.getTime());
    }

    public static <T> List<T> softCopyList(Collection<T> source) {
        if (source == null) {
            source = Collections.emptyList();
        }
        return new ArrayList<T>(source);
    }

    public static <T> List<T> softCopyUnmodifiableList(Collection<T> source) {
        return Collections.unmodifiableList(DomainUtils.softCopyList(source));
    }

    public static <T> Set<T> softCopySet(Collection<T> source) {
        if (source == null) {
            source = Collections.emptySet();
        }
        return new HashSet<T>(source);
    }

    public static <T> Set<T> softCopyUnmodifiableSet(Collection<T> source) {
        return Collections.unmodifiableSet(DomainUtils.softCopySet(source));
    }

    public static <T extends Comparable<?>> SortedSet<T> softCopySortedSet(Collection<T> source) {
        if (source == null) {
            source = Collections.emptySet();
        }
        return new TreeSet<T>(source);
    }

    public static <T extends Comparable<?>> SortedSet<T> softCopyUnmodifiableSortedSet(Collection<T> source) {
        return Collections.unmodifiableSortedSet(DomainUtils.softCopySortedSet(source));
    }

    public static <K, V> Map<K, V> softCopyMap(Map<K, V> source) {
        if (source == null) {
            source = Collections.emptyMap();
        }
        return new HashMap<K, V>(source);
    }

    public static <K, V> Map<K, V> softCopyUnmodifiableMap(Map<K, V> source) {
        return Collections.unmodifiableMap(DomainUtils.softCopyMap(source));
    }

    public static <K, V> SortedMap<K, V> softCopySortedMap(Map<K, V> source) {
        if (source == null) {
            source = Collections.emptySortedMap();
        }
        return new TreeMap<K, V>(source);
    }

    public static <K, V> SortedMap<K, V> softCopyUnmodifiableSortedMap(Map<K, V> source) {
        return Collections.unmodifiableSortedMap(DomainUtils.softCopySortedMap(source));
    }

    public static <K, V> Map<K, V> mergeMaps(Map<K, V> ... maps) {
        HashMap<K, V> res = new HashMap<K, V>();
        for (int i = 0; i < maps.length; ++i) {
            res.putAll(maps[i]);
        }
        return res;
    }

    public static <T> Set<T> createSet(T ... a) {
        return new HashSet<T>(Arrays.asList(a));
    }

    public static <K, V> Map<K, V> createMap(K key, V val, Object ... data) {
        HashMap<Object, Object> res = new HashMap<Object, Object>();
        res.put(key, val);
        for (int i = 0; i < data.length; i += 2) {
            res.put(data[i], data[i + 1]);
        }
        return res;
    }

    public static <T> List<List<T>> splitIntoLists(Collection<T> source, int max) {
        ValidationUtils.guardPositiveInt(max, "max must be positive number");
        List<T> sourceCopy = DomainUtils.softCopyList(source);
        if (sourceCopy.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<T>> res = new ArrayList<List<T>>();
        ArrayList<T> part = new ArrayList<T>();
        for (T obj : sourceCopy) {
            part.add(obj);
            if (part.size() != max) continue;
            res.add(part);
            part = new ArrayList();
        }
        if (!part.isEmpty()) {
            res.add(part);
        }
        return res;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document createDocumentFromXmlFile(File file) {
        Document document;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docBuilder.parse(is);
            ((InputStream)is).close();
            document = doc;
        }
        catch (ParserConfigurationException e) {
            try {
                throw new RuntimeException(e);
                catch (SAXException e2) {
                    throw new RuntimeException(e2);
                }
                catch (IOException e3) {
                    throw new RuntimeException(e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return document;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document createDocumentFromXmlBytes(byte[] bytes) {
        Document document;
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(bytes);
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docBuilder.parse(is);
            ((InputStream)is).close();
            document = doc;
        }
        catch (ParserConfigurationException e) {
            try {
                throw new RuntimeException(e);
                catch (SAXException e2) {
                    throw new RuntimeException(e2);
                }
                catch (IOException e3) {
                    throw new RuntimeException(e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return document;
    }

    public static Object getPropertyByEnum(Object obj, Enum<?> enm) {
        ValidationUtils.guardNotNull(obj, "obj cannot be null");
        ValidationUtils.guardNotNull(enm, "enm cannot be null");
        String name = enm.name().toLowerCase();
        String getterBase = "";
        boolean capital = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                capital = true;
                continue;
            }
            if (capital) {
                getterBase = getterBase + String.valueOf(c).toUpperCase();
                capital = false;
                continue;
            }
            getterBase = getterBase + String.valueOf(c);
        }
        Method method = null;
        Class<?> clazz = obj.getClass();
        try {
            method = clazz.getMethod("get" + getterBase, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                method = clazz.getMethod("is" + getterBase, new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                throw new IllegalArgumentException("getter doesn't exists: Class = " + clazz + "; Enum = " + enm);
            }
            catch (SecurityException e1) {
                throw new RuntimeException(e1);
            }
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        try {
            return method.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean safeEquals(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static <T> Map<String, Object> convertPropertyMapIntoVelocityModel(Map<String, T> properties) {
        Iterator iterator;
        ArrayList<Map<String, Object>> list;
        HashMap<String, Object> res = new HashMap<String, Object>();
        HashMap maps = new HashMap();
        HashMap arrayMaps = new HashMap();
        HashMap lists = new HashMap();
        for (String key : properties.keySet()) {
            String mapKey;
            String[] parts;
            if (key.matches("^[^\\.\\[\\]]+$")) {
                res.put(key, properties.get(key));
                continue;
            }
            if (key.matches("^[^\\[\\]]+\\..+$")) {
                parts = key.split("\\.", 2);
                mapKey = parts[0];
                String subKey = parts[1];
                if (!maps.containsKey(mapKey)) {
                    maps.put(mapKey, new HashMap());
                }
                ((Map)maps.get(mapKey)).put(subKey, properties.get(key));
                continue;
            }
            if (key.matches("^[^\\.]+\\[[0-9]+\\]\\..+$")) {
                parts = key.split("[\\[\\]]", 3);
                mapKey = parts[0];
                int index = Integer.valueOf(parts[1]);
                String subKey = parts[2].substring(1);
                if (!arrayMaps.containsKey(mapKey)) {
                    arrayMaps.put(mapKey, new TreeMap());
                }
                if (!((SortedMap)arrayMaps.get(mapKey)).containsKey(index)) {
                    ((SortedMap)arrayMaps.get(mapKey)).put(index, new HashMap());
                }
                ((Map)((SortedMap)arrayMaps.get(mapKey)).get(index)).put(subKey, properties.get(key));
                continue;
            }
            if (key.matches("^[^\\.]+\\[[0-9]+\\]$")) {
                parts = key.split("[\\[\\]]", 3);
                mapKey = parts[0];
                int index = Integer.valueOf(parts[1]);
                if (!lists.containsKey(mapKey)) {
                    lists.put(mapKey, new TreeMap());
                }
                ((SortedMap)lists.get(mapKey)).put(index, properties.get(key));
                continue;
            }
            throw new RuntimeException("unsupported property key, please implement me: key = " + key);
        }
        for (String key : maps.keySet()) {
            res.put(key, DomainUtils.convertPropertyMapIntoVelocityModel((Map)maps.get(key)));
        }
        for (String key : arrayMaps.keySet()) {
            list = new ArrayList<Map<String, Object>>();
            iterator = ((SortedMap)arrayMaps.get(key)).keySet().iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                list.add(DomainUtils.convertPropertyMapIntoVelocityModel((Map)((SortedMap)arrayMaps.get(key)).get(index)));
            }
            res.put(key, list);
        }
        for (String key : lists.keySet()) {
            list = new ArrayList();
            iterator = ((SortedMap)lists.get(key)).keySet().iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                list.add((Map<String, Object>)((SortedMap)lists.get(key)).get(index));
            }
            res.put(key, list);
        }
        return res;
    }

    public static Object buildObject(String className, Map<String, ? extends Object> configuration) {
        try {
            Class<?> builderClass = Class.forName(className + "$Builder");
            Constructor<?> constructor = builderClass.getConstructor(new Class[0]);
            Object builder = constructor.newInstance(new Object[0]);
            Method[] methods = builderClass.getMethods();
            for (String key : configuration.keySet()) {
                Object val = configuration.get(key);
                Method setter = null;
                for (Method candidate : methods) {
                    Class<?>[] parameters;
                    if (!candidate.getName().equals("set" + StringUtils.capitalize((String)key)) || (parameters = candidate.getParameterTypes()).length != 1) continue;
                    if (parameters[0].isPrimitive() && (parameters[0].equals(Double.TYPE) && val.getClass().equals(Double.class) || parameters[0].equals(Float.TYPE) && val.getClass().equals(Float.class) || parameters[0].equals(Long.TYPE) && val.getClass().equals(Long.class) || parameters[0].equals(Integer.TYPE) && val.getClass().equals(Integer.class) || parameters[0].equals(Byte.TYPE) && val.getClass().equals(Byte.class) || parameters[0].equals(Boolean.TYPE) && val.getClass().equals(Boolean.class))) {
                        setter = candidate;
                        continue;
                    }
                    if (!parameters[0].isAssignableFrom(val.getClass())) continue;
                    setter = candidate;
                }
                ValidationUtils.guardNotNull(setter, "unable to find setter: property = " + key);
                setter.invoke(builder, val);
            }
            Method build = builderClass.getMethod("build", new Class[0]);
            return build.invoke(builder, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object buildObjectFromXml(Node node, Map<String, ? extends Object> environment) {
        try {
            HashMap<String, Object> configuration = new HashMap<String, Object>();
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression nameExpr = xpath.compile("name");
            XPathExpression typeExpr = xpath.compile("type");
            XPathExpression valueExpr = xpath.compile("value");
            String className = xpath.compile("class").evaluate(node);
            NodeList properties = (NodeList)xpath.compile("configuration/property").evaluate(node, XPathConstants.NODESET);
            for (int i = 0; i < properties.getLength(); ++i) {
                Node propertyNode = properties.item(i);
                String name = nameExpr.evaluate(propertyNode);
                String type = typeExpr.evaluate(propertyNode);
                String value = valueExpr.evaluate(propertyNode);
                if (configuration.containsKey(name)) {
                    throw new IllegalArgumentException("property has been defined twice: property = " + name);
                }
                if (type.equals("String")) {
                    configuration.put(name, value);
                    continue;
                }
                if (type.equals("Double")) {
                    configuration.put(name, Double.valueOf(value));
                    continue;
                }
                if (type.equals("Float")) {
                    configuration.put(name, Float.valueOf(value));
                    continue;
                }
                if (type.equals("Long")) {
                    configuration.put(name, Long.valueOf(value));
                    continue;
                }
                if (type.equals("Integer")) {
                    configuration.put(name, Integer.valueOf(value));
                    continue;
                }
                if (type.equals("Byte")) {
                    configuration.put(name, Byte.valueOf(value));
                    continue;
                }
                if (type.equals("Boolean")) {
                    configuration.put(name, Boolean.valueOf(value));
                    continue;
                }
                if (type.equals("Enumeration")) {
                    int idx = value.lastIndexOf(".");
                    Class<?> clazz = Class.forName(value.substring(0, idx));
                    Method m = clazz.getMethod("valueOf", String.class);
                    Object val = m.invoke(null, value.substring(idx + 1));
                    configuration.put(name, val);
                    continue;
                }
                if (type.equals("Dependency")) {
                    if (environment.containsKey(value)) {
                        configuration.put(name, environment.get(value));
                        continue;
                    }
                    throw new IndexOutOfBoundsException("dependency not found in the environment: name = " + name + "; environment = " + environment);
                }
                throw new IllegalArgumentException("unsupported property type: name = " + name + "; type = " + type);
            }
            return DomainUtils.buildObject(className, configuration);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> buildEnvironmentFromXml(Node node, Map<String, ? extends Object> environment) {
        try {
            HashMap<String, Node> name2Node = new HashMap<String, Node>();
            HashSet<String> existingNames = new HashSet<String>(environment.keySet());
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression nameExpr = xpath.compile("name");
            NodeList objects = (NodeList)xpath.compile("object").evaluate(node, XPathConstants.NODESET);
            for (int i = 0; i < objects.getLength(); ++i) {
                Node objectNode = objects.item(i);
                String name = nameExpr.evaluate(objectNode);
                if (existingNames.contains(name)) {
                    throw new IllegalArgumentException("object name already exists, check environment and xml: name = " + name + "; environment = " + environment);
                }
                existingNames.add(name);
                name2Node.put(name, objectNode);
            }
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.putAll(environment);
            while (!name2Node.isEmpty()) {
                HashMap newName2Node = new HashMap(name2Node);
                for (String key : name2Node.keySet()) {
                    try {
                        Object object = DomainUtils.buildObjectFromXml((Node)name2Node.get(key), res);
                        res.put(key, object);
                        newName2Node.remove(key);
                    }
                    catch (IndexOutOfBoundsException e) {}
                }
                if (name2Node.size() == newName2Node.size()) {
                    throw new IndexOutOfBoundsException("unable to create all object, missing or circular dependency: remainingObjects = " + name2Node.keySet() + "; environment = " + environment);
                }
                name2Node = newName2Node;
            }
            return res;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

