/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.engine;

import com.enterprisemath.utils.DomainUtils;
import com.enterprisemath.utils.ValidationUtils;
import com.enterprisemath.utils.engine.TaskRunExceptionReport;
import com.enterprisemath.utils.engine.TaskRunListener;
import com.enterprisemath.utils.engine.TaskRunStopReport;
import com.enterprisemath.utils.engine.TaskRunSuccessReport;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;

public class ListTaskRunListener
implements TaskRunListener {
    private List<TaskRunListener> listeners;

    public ListTaskRunListener(Builder builder) {
        this.listeners = DomainUtils.softCopyUnmodifiableList(builder.listeners);
        this.guardInvariants();
    }

    private void guardInvariants() {
        ValidationUtils.guardNotNullCollection(this.listeners, "listeners cannot have null element");
    }

    @Override
    public void runFinishedBySuccess(TaskRunSuccessReport report) {
        for (TaskRunListener listener : this.listeners) {
            listener.runFinishedBySuccess(report);
        }
    }

    @Override
    public void runFinishedByExceptin(TaskRunExceptionReport report) {
        for (TaskRunListener listener : this.listeners) {
            listener.runFinishedByExceptin(report);
        }
    }

    @Override
    public void runFinishedByStop(TaskRunStopReport report) {
        for (TaskRunListener listener : this.listeners) {
            listener.runFinishedByStop(report);
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static ListTaskRunListener create(List<TaskRunListener> listeners) {
        return new Builder().setListeners(listeners).build();
    }

    public static class Builder {
        private List<TaskRunListener> listeners = new ArrayList<TaskRunListener>();

        public Builder setListeners(List<TaskRunListener> listeners) {
            this.listeners = DomainUtils.softCopyList(listeners);
            return this;
        }

        public Builder addListener(TaskRunListener listener) {
            this.listeners.add(listener);
            return this;
        }

        public ListTaskRunListener build() {
            return new ListTaskRunListener(this);
        }
    }
}

