/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.engine;

import com.enterprisemath.utils.ValidationUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TaskProgress {
    private Double progress;
    private String message;

    public TaskProgress(Builder builder) {
        this.progress = builder.progress;
        this.message = builder.message;
        this.guardInvariants();
    }

    private void guardInvariants() {
        ValidationUtils.guardNotNull(this.progress, "progress cannot be null");
        ValidationUtils.guardGreaterOrEqualDouble(this.progress, 0.0, "progress must be in interval [0, 1]");
        ValidationUtils.guardGreaterOrEqualDouble(1.0, this.progress, "progress must be in interval [0, 1]");
        ValidationUtils.guardNotNull(this.message, "message cannot be null");
    }

    public Double getProgress() {
        return this.progress;
    }

    public String getMessage() {
        return this.message;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static TaskProgress create(double progress) {
        return new Builder().setProgress(progress).build();
    }

    public static TaskProgress create(double progress, String message) {
        return new Builder().setProgress(progress).setMessage(message).build();
    }

    public static class Builder {
        private Double progress;
        private String message = "";

        public Builder setProgress(Double progress) {
            this.progress = progress;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public TaskProgress build() {
            return new TaskProgress(this);
        }
    }
}

