/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.image;

import com.enterprisemath.utils.ValidationUtils;
import com.enterprisemath.utils.image.ImageAnimation;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class BlendImageAnimation
implements ImageAnimation {
    private ImageAnimation bottom;
    private ImageAnimation top;
    private Double blendStart;
    private Double blendEnd;

    public BlendImageAnimation(Builder builder) {
        this.bottom = builder.bottom;
        this.top = builder.top;
        this.blendStart = builder.blendStart;
        this.blendEnd = builder.blendEnd;
        this.guardInvariants();
    }

    private void guardInvariants() {
        ValidationUtils.guardNotNull(this.bottom, "bottom cannot be null");
        ValidationUtils.guardNotNull(this.top, "top cannot be null");
        ValidationUtils.guardEquals(this.bottom.getFrameWidth(), this.top.getFrameWidth(), "frameWidth must be equal for both animation");
        ValidationUtils.guardEquals(this.bottom.getFrameHeight(), this.top.getFrameHeight(), "getFrameHeight must be equal for both animation");
        ValidationUtils.guardEquals(this.bottom.getFrameDuration(), this.top.getFrameDuration(), "getFrameDuration must be equal for both animation");
        ValidationUtils.guardEquals(this.bottom.getNumFrames(), this.top.getNumFrames(), "getNumFrames must be equal for both animation");
        ValidationUtils.guardGreaterOrEqualDouble(1.0, this.blendStart, "blendStart must be in interval [0, 1]");
        ValidationUtils.guardGreaterOrEqualDouble(this.blendStart, 0.0, "blendStart must be in interval [0, 1]");
        ValidationUtils.guardGreaterOrEqualDouble(1.0, this.blendEnd, "blendEnd must be in interval [0, 1]");
        ValidationUtils.guardGreaterOrEqualDouble(this.blendEnd, 0.0, "blendEnd must be in interval [0, 1]");
    }

    @Override
    public int getFrameWidth() {
        return this.bottom.getFrameWidth();
    }

    @Override
    public int getFrameHeight() {
        return this.bottom.getFrameHeight();
    }

    @Override
    public int getNumFrames() {
        return this.bottom.getNumFrames();
    }

    @Override
    public int getFrameDuration() {
        return this.bottom.getFrameDuration();
    }

    @Override
    public RenderedImage getFrame(int index) {
        RenderedImage bimg = this.bottom.getFrame(index);
        RenderedImage timg = this.top.getFrame(index);
        Raster brast = bimg.getData();
        Raster trast = timg.getData();
        double tt = this.blendStart + (this.blendEnd - this.blendStart) / (double)(this.bottom.getNumFrames() - 1) * (double)index;
        double tb = 1.0 - tt;
        BufferedImage res = new BufferedImage(this.bottom.getFrameWidth(), this.bottom.getFrameHeight(), 6);
        int[] bpix = new int[4];
        int[] tpix = new int[4];
        Color c = null;
        for (int x = 0; x < this.bottom.getFrameWidth(); ++x) {
            for (int y = 0; y < this.bottom.getFrameHeight(); ++y) {
                brast.getPixel(x, y, bpix);
                trast.getPixel(x, y, tpix);
                c = new Color((int)((double)bpix[0] * tb + (double)tpix[0] * tt), (int)((double)bpix[1] * tb + (double)tpix[1] * tt), (int)((double)bpix[2] * tb + (double)tpix[2] * tt), (int)((double)bpix[3] * tb + (double)tpix[3] * tt));
                res.setRGB(x, y, c.getRGB());
            }
        }
        return res;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static BlendImageAnimation create(ImageAnimation bottom, ImageAnimation top, double blendStart, double blendEnd) {
        return new Builder().setBottom(bottom).setTop(top).setBlendStart(blendStart).setBlendEnd(blendEnd).build();
    }

    public static class Builder {
        private ImageAnimation bottom;
        private ImageAnimation top;
        private Double blendStart;
        private Double blendEnd;

        public Builder setBottom(ImageAnimation bottom) {
            this.bottom = bottom;
            return this;
        }

        public Builder setTop(ImageAnimation top) {
            this.top = top;
            return this;
        }

        public Builder setBlendStart(double blendStart) {
            this.blendStart = blendStart;
            return this;
        }

        public Builder setBlendEnd(double blendEnd) {
            this.blendEnd = blendEnd;
            return this;
        }

        public BlendImageAnimation build() {
            return new BlendImageAnimation(this);
        }
    }
}

