/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.image;

import com.enterprisemath.utils.DomainUtils;
import com.enterprisemath.utils.ValidationUtils;
import com.enterprisemath.utils.image.ImageAnimation;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class CompositeImageAnimation
implements ImageAnimation {
    private Integer frameWidth;
    private Integer frameHeight;
    private List<SubAnimation> subAnimations;

    public CompositeImageAnimation(Builder builder) {
        this.frameWidth = builder.frameWidth;
        this.frameHeight = builder.frameHeight;
        this.subAnimations = Collections.unmodifiableList(DomainUtils.softCopyList(builder.subAnimations));
        this.guardInvariants();
    }

    private void guardInvariants() {
        ValidationUtils.guardPositiveInt(this.frameWidth, "frameWidth must be positive");
        ValidationUtils.guardPositiveInt(this.frameHeight, "frameHeight must be positive");
        ValidationUtils.guardPositiveInt(this.subAnimations.size(), "at least 1 sub animation must be defined");
        int frameDuration = this.subAnimations.get(0).getAnimation().getFrameDuration();
        int numFrames = this.subAnimations.get(0).getAnimation().getNumFrames();
        for (SubAnimation sa : this.subAnimations) {
            ValidationUtils.guardEquals(frameDuration, sa.getAnimation().getFrameDuration(), "frameDuration must be same for all animations in composite");
            ValidationUtils.guardEquals(numFrames, sa.getAnimation().getNumFrames(), "numFrames must be same for all animations in composite");
        }
    }

    @Override
    public int getFrameWidth() {
        return this.frameWidth;
    }

    @Override
    public int getFrameHeight() {
        return this.frameHeight;
    }

    @Override
    public int getNumFrames() {
        return this.subAnimations.get(0).getAnimation().getNumFrames();
    }

    @Override
    public int getFrameDuration() {
        return this.subAnimations.get(0).getAnimation().getFrameDuration();
    }

    @Override
    public RenderedImage getFrame(int index) {
        BufferedImage img = new BufferedImage(this.frameWidth, this.frameHeight, 6);
        Graphics2D g = (Graphics2D)img.getGraphics();
        for (SubAnimation sa : this.subAnimations) {
            AffineTransform at = AffineTransform.getTranslateInstance(sa.getX(), sa.getY());
            g.drawRenderedImage(sa.getAnimation().getFrame(index), at);
        }
        return img;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    private static class SubAnimation {
        private int x;
        private int y;
        private ImageAnimation animation;

        private SubAnimation(int x, int y, ImageAnimation animation) {
            this.x = x;
            this.y = y;
            this.animation = animation;
            this.guardInvariatns();
        }

        private void guardInvariatns() {
            ValidationUtils.guardNotNull(this.animation, "animation cannot be null");
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public ImageAnimation getAnimation() {
            return this.animation;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    public static class Builder {
        private Integer frameWidth;
        private Integer frameHeight;
        private List<SubAnimation> subAnimations = new ArrayList<SubAnimation>();

        public Builder setFrameWidth(Integer frameWidth) {
            this.frameWidth = frameWidth;
            return this;
        }

        public Builder setFrameHeight(Integer frameHeight) {
            this.frameHeight = frameHeight;
            return this;
        }

        public Builder addSubAnimation(int x, int y, ImageAnimation animation) {
            this.subAnimations.add(new SubAnimation(x, y, animation));
            return this;
        }

        public CompositeImageAnimation build() {
            return new CompositeImageAnimation(this);
        }
    }
}

