/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.image;

import com.enterprisemath.utils.ValidationUtils;
import com.enterprisemath.utils.image.ImageAnimation;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ConstantColorImageAnimation
implements ImageAnimation {
    private Integer frameWidth;
    private Integer frameHeight;
    private Integer frameDuration;
    private Integer numFrames;
    private Color color;

    public ConstantColorImageAnimation(Builder builder) {
        this.frameWidth = builder.frameWidth;
        this.frameHeight = builder.frameHeight;
        this.frameDuration = builder.frameDuration;
        this.numFrames = builder.numFrames;
        this.color = builder.color;
        this.guardInvariants();
    }

    private void guardInvariants() {
        ValidationUtils.guardPositiveInt(this.frameWidth, "frameWidth must be positive");
        ValidationUtils.guardPositiveInt(this.frameHeight, "frameHeight must be positive");
        ValidationUtils.guardPositiveInt(this.frameDuration, "frameDuration must be positive");
        ValidationUtils.guardNotNegativeInt(this.numFrames, "numFrames cannot be negative");
        ValidationUtils.guardNotNull(this.color, "color cannot be null");
    }

    @Override
    public int getFrameWidth() {
        return this.frameWidth;
    }

    @Override
    public int getFrameHeight() {
        return this.frameHeight;
    }

    @Override
    public int getNumFrames() {
        return this.numFrames;
    }

    @Override
    public int getFrameDuration() {
        return this.frameDuration;
    }

    @Override
    public RenderedImage getFrame(int index) {
        BufferedImage img = new BufferedImage(this.frameWidth, this.frameHeight, 6);
        Graphics g = img.getGraphics();
        g.setColor(this.color);
        g.fill3DRect(0, 0, this.frameWidth + 1, this.frameHeight + 1, false);
        return img;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static ConstantColorImageAnimation create(int frameWidth, int frameHeight, int frameDuration, int numFrames, Color color) {
        return new Builder().setFrameWidth(frameWidth).setFrameHeight(frameHeight).setFrameDuration(frameDuration).setNumFrames(numFrames).setColor(color).build();
    }

    public static class Builder {
        private Integer frameWidth;
        private Integer frameHeight;
        private Integer frameDuration;
        private Integer numFrames;
        private Color color;

        public Builder setFrameWidth(Integer frameWidth) {
            this.frameWidth = frameWidth;
            return this;
        }

        public Builder setFrameHeight(Integer frameHeight) {
            this.frameHeight = frameHeight;
            return this;
        }

        public Builder setFrameDuration(Integer frameDuration) {
            this.frameDuration = frameDuration;
            return this;
        }

        public Builder setNumFrames(Integer numFrames) {
            this.numFrames = numFrames;
            return this;
        }

        public Builder setColor(Color color) {
            this.color = color;
            return this;
        }

        public ConstantColorImageAnimation build() {
            return new ConstantColorImageAnimation(this);
        }
    }
}

