/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.image;

import com.enterprisemath.utils.DomainUtils;
import com.enterprisemath.utils.ValidationUtils;
import com.enterprisemath.utils.image.ImageAnimation;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class FileListImageAnimation
implements ImageAnimation {
    private Integer frameWidth;
    private Integer frameHeight;
    private Integer frameDuration;
    private List<String> framePaths;

    public FileListImageAnimation(Builder builder) {
        this.frameWidth = builder.frameWidth;
        this.frameHeight = builder.frameHeight;
        this.frameDuration = builder.frameDuration;
        this.framePaths = Collections.unmodifiableList(DomainUtils.softCopyList(builder.framePaths));
        this.guardInvariants();
    }

    private void guardInvariants() {
        ValidationUtils.guardPositiveInt(this.frameWidth, "frameWidth must be positive");
        ValidationUtils.guardPositiveInt(this.frameHeight, "frameHeight must be positive");
        ValidationUtils.guardPositiveInt(this.frameDuration, "frameDuration must be positive");
        ValidationUtils.guardNotEmptyStringInCollection(this.framePaths, "framePaths cannot have empty element");
    }

    @Override
    public int getFrameWidth() {
        return this.frameWidth;
    }

    @Override
    public int getFrameHeight() {
        return this.frameHeight;
    }

    @Override
    public int getNumFrames() {
        return this.framePaths.size();
    }

    @Override
    public int getFrameDuration() {
        return this.frameDuration;
    }

    @Override
    public RenderedImage getFrame(int index) {
        try {
            BufferedImage img = ImageIO.read(new File(this.framePaths.get(index)));
            ValidationUtils.guardEquals(this.frameWidth, img.getWidth(), "image width does not match the frameWidth: frameWidth = " + this.frameWidth + "; " + "imageWidth = " + img.getWidth() + "; " + "path = " + this.framePaths.get(index));
            ValidationUtils.guardEquals(this.frameHeight, img.getHeight(), "image height does not match the frameHeight: frameHeight = " + this.frameHeight + "; " + "imageHeight = " + img.getHeight() + "; " + "path = " + this.framePaths.get(index));
            return img;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static class Builder {
        private Integer frameWidth;
        private Integer frameHeight;
        private Integer frameDuration;
        private List<String> framePaths = new ArrayList<String>();

        public Builder setFrameWidth(Integer frameWidth) {
            this.frameWidth = frameWidth;
            return this;
        }

        public Builder setFrameHeight(Integer frameHeight) {
            this.frameHeight = frameHeight;
            return this;
        }

        public Builder setFrameDuration(Integer frameDuration) {
            this.frameDuration = frameDuration;
            return this;
        }

        public Builder setFramePaths(List<String> framePaths) {
            this.framePaths = DomainUtils.softCopyList(framePaths);
            return this;
        }

        public Builder addFramePath(String framePath) {
            this.framePaths.add(framePath);
            return this;
        }

        public FileListImageAnimation build() {
            return new FileListImageAnimation(this);
        }
    }
}

