/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.image;

import com.enterprisemath.utils.DomainUtils;
import com.enterprisemath.utils.ValidationUtils;
import com.enterprisemath.utils.image.ImageAnimation;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class SequenceImageAnimation
implements ImageAnimation {
    private List<ImageAnimation> animations;

    public SequenceImageAnimation(Builder builder) {
        this.animations = Collections.unmodifiableList(DomainUtils.softCopyList(builder.animations));
        this.guardInvariants();
    }

    private void guardInvariants() {
        ValidationUtils.guardNotNullCollection(this.animations, "animations cannot have null elemen");
        ValidationUtils.guardPositiveInt(this.animations.size(), "at least one animation must be defined");
        int w = this.animations.get(0).getFrameWidth();
        int h = this.animations.get(0).getFrameHeight();
        int d = this.animations.get(0).getFrameDuration();
        for (ImageAnimation a : this.animations) {
            ValidationUtils.guardEquals(w, a.getFrameWidth(), "frameWidth must be same for all animations in sequence");
            ValidationUtils.guardEquals(h, a.getFrameHeight(), "frameHeight must be same for all animations in sequence");
            ValidationUtils.guardEquals(d, a.getFrameDuration(), "frameDuration must be same for all animations in sequence");
        }
    }

    @Override
    public int getFrameWidth() {
        return this.animations.get(0).getFrameWidth();
    }

    @Override
    public int getFrameHeight() {
        return this.animations.get(0).getFrameHeight();
    }

    @Override
    public int getNumFrames() {
        int res = 0;
        for (ImageAnimation a : this.animations) {
            res += a.getNumFrames();
        }
        return res;
    }

    @Override
    public int getFrameDuration() {
        return this.animations.get(0).getFrameDuration();
    }

    @Override
    public RenderedImage getFrame(int index) {
        for (ImageAnimation a : this.animations) {
            if (index < a.getNumFrames()) {
                return a.getFrame(index);
            }
            index -= a.getNumFrames();
        }
        throw new IndexOutOfBoundsException("frame index is out of bound: index = " + index);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static class Builder {
        private List<ImageAnimation> animations = new ArrayList<ImageAnimation>();

        public Builder setAnimations(List<ImageAnimation> animations) {
            this.animations = DomainUtils.softCopyList(animations);
            return this;
        }

        public Builder addAnimation(ImageAnimation animation) {
            this.animations.add(animation);
            return this;
        }

        public SequenceImageAnimation build() {
            return new SequenceImageAnimation(this);
        }
    }
}

