/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.messaging;

import com.enterprisemath.utils.ValidationUtils;
import java.util.Arrays;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Attachment {
    private byte[] buf;
    private String name;
    private String mime;

    public Attachment(Builder builder) {
        this.buf = Arrays.copyOf(builder.buf, builder.buf.length);
        this.name = builder.name;
        this.mime = builder.mime;
        this.guardInvariants();
    }

    private void guardInvariants() {
        ValidationUtils.guardNotNull(this.buf, "buffer cannot be null");
        ValidationUtils.guardNotEmpty(this.name, "name cannot be empty");
        ValidationUtils.guardNotNull(this.mime, "mime cannot be null");
    }

    public byte[] getBuf() {
        return Arrays.copyOf(this.buf, this.buf.length);
    }

    public String getName() {
        return this.name;
    }

    public String getMime() {
        return this.mime;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static Attachment create(String name, String mime, byte[] buf) {
        return new Builder().setName(name).setMime(mime).setBuf(buf).build();
    }

    public static class Builder {
        private byte[] buf;
        private String name;
        private String mime;

        public Builder setBuf(byte[] buf) {
            this.buf = Arrays.copyOf(buf, buf.length);
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setMime(String mime) {
            this.mime = mime;
            return this;
        }

        public Attachment build() {
            return new Attachment(this);
        }
    }
}

