/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.messaging;

import com.enterprisemath.utils.Dates;
import com.enterprisemath.utils.DatesProvider;
import com.enterprisemath.utils.DomainUtils;
import com.enterprisemath.utils.ValidationUtils;
import com.enterprisemath.utils.messaging.Attachment;
import com.enterprisemath.utils.messaging.Message;
import com.enterprisemath.utils.messaging.MessageTemplateProvider;
import com.enterprisemath.utils.messaging.Messenger;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;

public class FileMessenger
implements Messenger {
    private String outputDirectoryPath;
    private MessageTemplateProvider templateProvider;
    private Map<String, Object> defaultModel;
    private VelocityEngine velocityEngine;
    private DatesProvider datesProvider;

    private FileMessenger() {
    }

    @PostConstruct
    private void guardInvariants() {
        ValidationUtils.guardNotEmpty(this.outputDirectoryPath, "outputDirectoryPath cannot be empty");
        ValidationUtils.guardNotNull(this.templateProvider, "templateProvider cannot be null");
        ValidationUtils.guardNotEmptyNullMap(this.defaultModel, "defaultModel cannot have empty key or null value");
        ValidationUtils.guardNotNull(this.velocityEngine, "velocityEngine cannot be null");
        ValidationUtils.guardNotNull(this.datesProvider, "datesProvider cannot be null");
    }

    @Override
    public synchronized void send(String target, Message message) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.putAll(this.defaultModel);
        model.putAll(DomainUtils.convertPropertyMapIntoVelocityModel(message.getParameters()));
        String subject = this.applyTemplate(this.templateProvider.getTemplate(message.getType(), "subject"), model);
        String text = this.applyTemplate(this.templateProvider.getTemplate(message.getType(), "message"), model);
        String dateStr = Dates.format(this.datesProvider.now(), "yyyy-MM-dd-HH-mm-ss");
        File headerFile = new File(this.outputDirectoryPath + "/" + dateStr + "-header.txt");
        File messageFile = new File(this.outputDirectoryPath + "/" + dateStr + "-message.html");
        File directory = headerFile.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            throw new RuntimeException("error during directory creation: path = " + directory.getAbsolutePath());
        }
        try {
            String headerTxt = target + "\n" + subject;
            FileUtils.writeStringToFile((File)headerFile, (String)headerTxt, (String)"utf-8");
            FileUtils.writeStringToFile((File)messageFile, (String)text, (String)"utf-8");
            for (Attachment att : message.getAttachments()) {
                File attFile = new File(this.outputDirectoryPath + "/" + dateStr + "-" + att.getName());
                FileUtils.writeByteArrayToFile((File)attFile, (byte[])att.getBuf());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public String applyTemplate(String templateLocation, Map<?, ?> model) {
        StringWriter result = new StringWriter();
        try {
            VelocityContext velocityContext = new VelocityContext(model);
            this.velocityEngine.mergeTemplate(templateLocation, "utf-8", (Context)velocityContext, (Writer)result);
        }
        catch (VelocityException e) {
            throw new RuntimeException(e);
        }
        return result.toString();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static FileMessenger create(String outputDirectoryPath, MessageTemplateProvider templateProvider, Map<String, Object> defaultModel, VelocityEngine velocityEngine, DatesProvider datesProvider) {
        FileMessenger res = new FileMessenger();
        res.outputDirectoryPath = outputDirectoryPath;
        res.templateProvider = templateProvider;
        res.defaultModel = DomainUtils.softCopyUnmodifiableMap(defaultModel);
        res.velocityEngine = velocityEngine;
        res.datesProvider = datesProvider;
        res.guardInvariants();
        return res;
    }
}

