/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisemath.utils.messaging;

import com.enterprisemath.utils.DomainUtils;
import com.enterprisemath.utils.ValidationUtils;
import com.enterprisemath.utils.messaging.Attachment;
import com.enterprisemath.utils.messaging.Message;
import com.enterprisemath.utils.messaging.MessageTemplateProvider;
import com.enterprisemath.utils.messaging.Messenger;
import com.enterprisemath.utils.messaging.TransportSecurity;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.annotation.PostConstruct;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;

public class SmtpMessenger
implements Messenger {
    private String smtpHost;
    private Integer smtpPort;
    private TransportSecurity transportSecurity;
    private String username;
    private String password;
    private Integer socketFactoryPort;
    private String from;
    private String replyTo;
    private MessageTemplateProvider templateProvider;
    private Map<String, Object> defaultModel;
    private VelocityEngine velocityEngine;

    private SmtpMessenger() {
    }

    @PostConstruct
    private void guardInvariants() {
        ValidationUtils.guardNotEmpty(this.smtpHost, "smtpHost cannot be empty");
        ValidationUtils.guardNotNull(this.smtpPort, "smtpPort cannot be null");
        ValidationUtils.guardNotNull((Object)this.transportSecurity, "transportSecurity cannot be null");
        if (this.transportSecurity.equals((Object)TransportSecurity.NONE)) {
            ValidationUtils.guardEmpty(this.username, "username must be empty for non secured transport");
            ValidationUtils.guardEmpty(this.password, "password must be empty for non secured transport");
        } else {
            ValidationUtils.guardNotEmpty(this.username, "username cannot be empty for secured transport");
            ValidationUtils.guardNotEmpty(this.password, "password cannot be empty for secured transport");
        }
        if (this.transportSecurity.equals((Object)TransportSecurity.SSL)) {
            ValidationUtils.guardNotNull(this.socketFactoryPort, "socketFactoryPort cannot be null for SSL transport");
        } else {
            ValidationUtils.guardNull(this.socketFactoryPort, "socketFactoryPort must be null for non SSL transport");
        }
        ValidationUtils.guardNotEmpty(this.from, "from cannot be empty");
        ValidationUtils.guardNotEmpty(this.replyTo, "replyTo cannot be empty");
        ValidationUtils.guardNotNull(this.templateProvider, "templateProvider cannot be null");
        ValidationUtils.guardNotEmptyNullMap(this.defaultModel, "defaultModel cannot have empty key or null value");
        ValidationUtils.guardNotNull(this.velocityEngine, "velocityEngine cannot be null");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void send(String target, Message message) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.putAll(this.defaultModel);
        model.putAll(DomainUtils.convertPropertyMapIntoVelocityModel(message.getParameters()));
        String subject = this.applyTemplate(this.templateProvider.getTemplate(message.getType(), "subject"), model);
        String text = this.applyTemplate(this.templateProvider.getTemplate(message.getType(), "message"), model);
        try {
            boolean end = false;
            int count = 0;
            while (!end) {
                try {
                    this.sendOneTry(target, subject, text, message.getAttachments());
                    return;
                }
                catch (MessagingException e) {
                    if (count >= 5) throw e;
                    if (!(e.getCause() instanceof ConnectException)) {
                        throw e;
                    }
                    ++count;
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException e1) {
                        throw new RuntimeException(e1);
                    }
                }
            }
            return;
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    private void sendOneTry(String target, String subject, String text, List<Attachment> attachments) throws MessagingException {
        ByteArrayDataSource source;
        MimeBodyPart attachmentBodyPart;
        Session session = this.createSession();
        HashMap<String, Attachment> imageCids2Attachemnts = new HashMap<String, Attachment>();
        Pattern pattern = Pattern.compile(".*img.*src=\"(data:image/(png|gif);base64,([^\"]*)\").*", 32);
        Matcher matcher = pattern.matcher(text);
        int i = 0;
        while (matcher.matches()) {
            String cid = "embeddedImage" + i;
            Attachment att = new Attachment.Builder().setName(cid + "." + matcher.group(2)).setMime("image/" + matcher.group(2)).setBuf(Base64.decodeBase64((String)matcher.group(3))).build();
            imageCids2Attachemnts.put(cid, att);
            text = text.substring(0, matcher.start(1)) + "cid:" + cid + text.substring(matcher.end(1) - 1);
            matcher = pattern.matcher(text);
            ++i;
        }
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setText(text, "utf-8", "html");
        multipart.addBodyPart((BodyPart)messageBodyPart);
        for (Attachment attachment : attachments) {
            attachmentBodyPart = new MimeBodyPart();
            source = new ByteArrayDataSource(attachment.getBuf(), attachment.getMime());
            attachmentBodyPart.setDataHandler(new DataHandler((DataSource)source));
            attachmentBodyPart.setFileName(attachment.getName());
            multipart.addBodyPart((BodyPart)attachmentBodyPart);
        }
        for (Map.Entry entry : imageCids2Attachemnts.entrySet()) {
            attachmentBodyPart = new MimeBodyPart();
            source = new ByteArrayDataSource(((Attachment)entry.getValue()).getBuf(), ((Attachment)entry.getValue()).getMime());
            attachmentBodyPart.setDataHandler(new DataHandler((DataSource)source));
            attachmentBodyPart.setFileName(((Attachment)entry.getValue()).getName());
            attachmentBodyPart.setContentID("<" + (String)entry.getKey() + ">");
            attachmentBodyPart.setDisposition("inline");
            multipart.addBodyPart((BodyPart)attachmentBodyPart);
        }
        MimeMessage mimeMsg = new MimeMessage(session);
        mimeMsg.setSentDate(new Date());
        mimeMsg.setFrom((Address)new InternetAddress(this.from));
        mimeMsg.setReplyTo(new Address[]{new InternetAddress(this.replyTo)});
        mimeMsg.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(target));
        mimeMsg.setSubject(subject);
        mimeMsg.setContent((Multipart)multipart);
        mimeMsg.saveChanges();
        Transport.send((javax.mail.Message)mimeMsg);
    }

    private Session createSession() {
        Properties props = null;
        Session session = null;
        switch (this.transportSecurity) {
            case NONE: {
                props = new Properties();
                props.put("mail.smtp.host", this.smtpHost);
                props.put("mail.smtp.port", Integer.toString(this.smtpPort));
                props.put("mail.from", this.from);
                session = Session.getInstance((Properties)props, null);
                break;
            }
            case SSL: {
                props = new Properties();
                props.put("mail.smtp.host", this.smtpHost);
                props.put("mail.smtp.auth", "true");
                props.put("mail.smtp.port", Integer.toString(this.smtpPort));
                props.put("mail.smtp.socketFactory.port", Integer.toString(this.socketFactoryPort));
                props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(SmtpMessenger.this.username, SmtpMessenger.this.password);
                    }
                });
                break;
            }
            case TLS: {
                props = new Properties();
                props.put("mail.smtp.host", this.smtpHost);
                props.put("mail.smtp.auth", "true");
                props.put("mail.smtp.port", Integer.toString(this.smtpPort));
                props.put("mail.smtp.starttls.enable", "true");
                session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(SmtpMessenger.this.username, SmtpMessenger.this.password);
                    }
                });
                break;
            }
            default: {
                throw new IllegalStateException("unsupported transport security - implement me if you need");
            }
        }
        return session;
    }

    public String applyTemplate(String templateLocation, Map<?, ?> model) {
        StringWriter result = new StringWriter();
        try {
            VelocityContext velocityContext = new VelocityContext(model);
            this.velocityEngine.mergeTemplate(templateLocation, "utf-8", (Context)velocityContext, (Writer)result);
        }
        catch (VelocityException e) {
            throw new RuntimeException(e);
        }
        return result.toString();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static SmtpMessenger create(String smtpHost, Integer smtpPort, TransportSecurity transportSecurity, String username, String password, Integer socketFactoryPort, String from, String replyTo, MessageTemplateProvider templateProvider, Map<String, Object> defaultModel, VelocityEngine velocityEngine) {
        SmtpMessenger res = new SmtpMessenger();
        res.smtpHost = smtpHost;
        res.smtpPort = smtpPort;
        res.transportSecurity = transportSecurity;
        res.username = username;
        res.password = password;
        res.socketFactoryPort = socketFactoryPort;
        res.from = from;
        res.replyTo = replyTo;
        res.templateProvider = templateProvider;
        res.defaultModel = DomainUtils.softCopyUnmodifiableMap(defaultModel);
        res.velocityEngine = velocityEngine;
        res.guardInvariants();
        return res;
    }
}

