/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.db;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;

import com.entitystream.monster.db.Document;



public class BaseNode {
	private String id;
	private Document props;
	
	private String tableName;
	private String keyName;
	private String keyValue;
	private boolean match;
	public BaseNode(String id, Document values, String tableName, String keyName, String keyValue, boolean match) {
			this.match=match;
			this.keyName=keyName;
			this.keyValue=keyValue;
			props= values;
			
			if (tableName!=null)
				this.tableName=tableName;
			else
			    if (values!=null && values.get("Table")!=null)
			       this.tableName=(String) values.get("Table");
			if (id==null)
			    this.id=keyName+":"+keyValue;
			else 
			    this.id=id;		 
	}
	
	
	
	public BaseNode(String id, Document values, String tableName, boolean match) {
		this.match=match;
		this.id=id;
		props= values;
		
		if (tableName!=null)
			this.tableName=tableName;
		else
		if (values!=null && values.get("Table")!=null)
		   this.tableName=(String) values.get("Table");
	
	}

	
	public BaseNode(String id, String keyName, String keyValue) {
		this.match=false;
		if (id==null)
		    this.id=keyName+":"+keyValue;
		else 
		    this.id=id;
		props= new Document(keyName, keyValue);
	
	}

	private Object clone(Object val){
		if (val instanceof String)
			return new String((String) val);
		else if (val instanceof Long)
			return new Long((Long)val);
		else if (val instanceof Integer)
			return new Integer((Integer) val);
		else if (val instanceof Date)
			return ((Date) val).clone();
		else if (val instanceof LocalDateTime)
			return Date.from(((LocalDateTime)val).toInstant(ZoneOffset.UTC));
		else if (val instanceof Double)
			return ((Double) val);
		else if (val instanceof Boolean)
			return (((Boolean) val).booleanValue());
		else if (val instanceof ArrayList){
			ArrayList newone = new ArrayList();
			for (Object item : (ArrayList)val)
			    newone.add(clone(item));
			return newone;
		}
		else {
			System.out.println(val.getClass().getName());
			return null;
		}
	}
	

	public String getId() {
		if (id!=null)
		    return id;
		else 
		    return keyName+":"+keyValue;
	}

	public Document getProperties() {
		return props;
	}

	public String getTableName() {
		return tableName;
	}

	public void setProperty(String property, Object value) {
		props.put(property, value);		
	}

	public String getKeyName() {
		return keyName;
	}

	public void setKeyName(String keyName) {
		this.keyName = keyName;
	}

	public String getKeyValue() {
		return keyValue;
	}

	public void setKeyValue(String keyValue) {
		this.keyValue = keyValue;
	}
	
	public Document getDocument(){
		Document out = new Document(props);
		out.append("Table", tableName);
		return out;
		
	}

	public void setProperties(Document vals) {
		this.props=vals;
		
	}

	public void setMatch(boolean m) {
		match=m;
	}
	
	public boolean match() {
		
		return match;
	}



}
