/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.db;

import java.util.Date;
import java.util.Map;

import com.entitystream.monster.db.Document;

public class BaseRelationship {
	private String id;
	private String one;
	private String two;
	private String table1;
	private String table2;
	private String type;
	private Map<String, Object> values;
	private Date when;
	private String status="ACTIVE";
	private String user="LOAD";
	public BaseRelationship(String id, String one, String two, String table1, String table2, String type, Map<String, Object> values, Date when, String username, String status){
		this.id=id;
		this.one=one;
		this.two=two;
		this.type=type;
		this.setTable1(table1);
		this.setTable2(table2);
		this.values=values;	
		this.when=when;
	}
	public BaseRelationship(String relID) {
		this.id=relID;
	}
	public Map<String, Object> getProperties() {
		return values;
	}
	public void setProperties(Map<String, Object> vals) {
		values=vals;
	}
	public String getID() {
		// TODO Auto-generated method stub
		return id;
	}
	public String getOtherNode() {
		// TODO Auto-generated method stub
		return two;
	}
	public String getNode() {
		// TODO Auto-generated method stub
		return one;
	}
	public String getRelType() {
		// TODO Auto-generated method stub
		return type;
	}
	public Date getWhen() {
		return when;
	}
	public Object getStatus() {
		// TODO Auto-generated method stub
		return status;
	}
	public Object getUser() {
		// TODO Auto-generated method stub
		return user;
	}
	public String getTable2() {
		return table2;
	}
	public void setTable2(String table2) {
		this.table2 = table2;
	}
	public String getTable1() {
		return table1;
	}
	public void setTable1(String table1) {
		this.table1 = table1;
	}
	public Document getAsDocument() {
		Document r = new Document();
		r.append("id",id);
		r.append("fromCol",one);
		r.append("toCol",two);
		r.append("reltype",type);
		r.append("fromTable",table1);
		r.append("toTable",table2);
		r.append("values",values);	
		r.append("lastUpdate",when);
		return r;
	}
}
