/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.db;

import java.util.HashSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import com.entitystream.monster.db.Document;

public class CommitItem implements WorkTypes {
	
	protected BaseNode baseNode = null;
	public HashSet<BaseRelationship> addRelCache;
	public HashSet<BaseRelationship> delRelCache;
	public int action;
	private boolean active=true;
	private Lock lock=new ReentrantLock();

	public static CommitItem add(BaseNode node) {
		CommitItem item = new CommitItem(node, ADD);
		
		return item;
	}
	
	public static CommitItem delete(BaseNode node) {
		CommitItem item = new CommitItem(node, DELETE);
		return item;
	}
	
	
	
    private CommitItem(BaseNode nde, int type) {
    	addRelCache = new HashSet<BaseRelationship>();
    	delRelCache = new HashSet<BaseRelationship>();
    	this.baseNode=nde;
    	this.action=type;
    }
    
    public void addRelationship(BaseRelationship rel) {
    	addRelCache.add(rel);
    }
    
    public void deleteRelationship(BaseRelationship rel) {
    	delRelCache.add(rel);
    }

	public String getID() {
		if (baseNode!=null)
		   return baseNode.getId();
		else return null;
	}

	public BaseNode getNode() {
		return baseNode;
	}

	public void suspend() {
		lock.lock();
		active=false;	
	}
	public void activate() {
		lock.unlock();
		active=true;	
	}

	public void setValues(Document values) {
		baseNode.setProperties(values);	
	}

	public boolean isActive() {
		return active;
	}

	public int getAction() {
		return action;
	}
	
	
	public void setAction(int act) {
		action=act;
	}
}