/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.ejb.Remote;
import javax.ejb.Stateful;

import com.entitystream.monster.db.Document;
import com.google.gson.JsonObject;
import com.entitystream.identiza.entity.resolve.match.MatchIndexInterface;
import com.entitystream.identiza.entity.resolve.match.MatchRecordInterface;
import com.entitystream.identiza.entity.resolve.metadata.ISchemaMeta;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumn;
import com.entitystream.identiza.entity.resolve.processing.IdentizaException;
import com.entitystream.identiza.entity.resolve.storage.Result;
import com.entitystream.identiza.metadata.IUser;


public interface DBWorker {

   
    public void setCommitSize(int commitSize);

    public ExecutorService getThreadPool();

    public List<Document>  getTaskTypes(IUser user);

    public List<Document> listCollections();

    public int getCommitSize();

    /*public long addInternalRelationship(String reltype,
			String dir, long one, long two);
     */

    public ArrayList<Document> search(HashMap<String, String> matchC, String table) throws IdentizaException;


    public RelationshipType getRelType(String arg0);

    public String getID();

    //node methods
    public boolean hasNodeProperty(String node, String arg0);

    public Document setNodeProperty(String node, String arg0, Object arg1);

    public Document deleteNode(String node, String survivedBy);


    public ArrayList<String> getNodeRelationships(String node, Date when);

    public String getNodeSingleRelationship(String node, String arg0, String arg1, Date when);

    public Object getNodeProperty(String node, String arg0);

    
    //relatinship methods
    public Object getRelProperty(String rel,String propname, Date when);
    public boolean hasRelProperty(String rel,String propname, Date when);
    public Object removeRelProperty(String rel,String propname, Date when);
    public Object setRelProperty(String rel,String propname,Object value, Date when);	 
    public Object deleteRel(String rel, Date when);

    public String getRelEndNode(String rel, Date when);
    public String[] getRelNodes(String rel, Date when);
    public String getRelOtherNode(String rel, String node, Date when);
    public String getRelStartNode(String rel, Date when);

    public String getRelType(String rel, Date when);	
    public boolean isRelType(String rel,String arg0, Date when);

    public boolean isActive();

    public void shutdown();

   
    public void clear(Collection<String> tableNames);




    Document getRelProperties(String rel, Date when);

    

    public long getNextId(String table) throws Exception;

    public long getTableCount(String tableName);




    public Document removeNodeProperty(String rel, String propname, Date when);


    public Iterator<Document> getLazyNodes(String tableName, int rowCount, Document where);

   
    public void addNode(String id, String tabletype);

    public long getNextRelId() throws Exception;

    public long getNextNodeId(boolean isInternal) throws Exception;

    public Map<String, Integer> getKeyThresholds();



   
    void sync(HashMap<String, ArrayList<MatchIndexInterface>> tableIndexes);

    Map<Object, Object> getSequenceValues();

    void writeSequence(String tabletype, long seq, long seqM);


    ArrayList<String> getNodeRelationships(String node, String reltype, String dir, Date when);

    ArrayList<String> getNodeRelationships(String node, String arg0, Date when);


    void truncate(String tableName, Document filter);

    public ArrayList<Document> getRelationships(int start, int end, Document where);

    public void putSchedule(Document job);

    public List<Document> findRule(String rulePurpose, String query);

    public String updateRule(Document doc);

    public void addMessage(Document d);

    public List<Document> getMessages(Date since);

    public List<JsonObject> getSuspended(int p);

    Iterable<JsonObject> getAllSuspended(String table);

    List<Document> getScheduledJobs();

    String getSchedule(String schema, String project);

    public Document getNode(String id);

    public void checkIndexes();

    Document createOrUpdateNode(String keyName, String keyValue, Document values, String tabletype,
	    boolean keychanged, boolean isHistory, String username);


    Document getJob(String jobID);

    public void clearTableCount();

    Map<String, Document> getMarketConnections(String groupName);

    ArrayList<String> getKeyList(String selectiveField, String selectiveValue, String indexName, int maxNodes);


    List<String> getRelTypes();

    Collection<Document> getFileListeners(String type, String listenerID);

    Collection<Document> getFileListeners(String type, String listenerID, String schema, String project,
	    String group);

    public void addListener(String type, Document doc, String name, String projectName, String groupName);

    void deleteListener(Document doc, String schemaName, String projectName, String groupName);

    public Collection<Document> analyseBy(List<PurposeColumn> purposeColumns);

    void addConnector(String connector, Document params, String groupName);

    Collection<Document> analyseBy(String tableName);


    void releaseRecord(String threadID, CommitItem item);

    public Map<String, Integer> taskCount(String subject);

   
    Document setNodeValues(String node, Document vals);

    public void updateTask(String taskID, Document document);

    DBWorkerBatch createBatchDB();

    public void deleteMessage(Document d);

    Document getRelationship(Document where, Date when);

   
    public Document getLatestForRelDoc(Document document, Date when);

    public ISchemaMeta getSchDoc();


    public void setSchDoc(ISchemaMeta schDoc);

    public Collection<Result> findFuzzy(Document filter);

    public Collection<Result> findFuzzy(String searchText);

    
    ArrayList<Document> getNodes(String tableName, String keyName, String keyValue, int maxBucketSize);

  
    Document getNode(String tableName, String keyName, String keyValue);

  

   
      Map<String, Document> find(String tableName, int startRow, int rowCount, Document _where, Document _sort);

  
   
   

    

    /**
     * @param node
     * @param table1
     * @param otherid
     * @param table2
     * @param reltype
     * @param values
     * @param when
     * @return
     */
    Document createNodeRelationshipTo(String node, String table1, String otherid, String table2, String reltype,
	    Map<String, Object> values, Date when);

    /**
     * @param node
     * @return
     */
    Map<String, Object> getNodeValues(String node);

    /**
     * @param validTables
     * @param rec1id
     * @param rec2id
     * @param when
     * @return
     */
    ArrayList<String> findShortestPath(ArrayList<String> validTables, String rec1id, String rec2id, Date when);

    /**
     * @param rel
     * @param vals
     * @param when
     */
    void setRelProperties(String rel, Document vals, Date when);

    /**
     * @param filter
     * @return
     */
    public Collection<Result> find(Document filter);

    /**
     * @param storeName
     */
    public void createStore(String storeName);

    /**
     * @return
     */
    public List<Document> getFlows();

    /**
     * @param flow
     * @param context
     * @return
     */
    public String executeFlow(String flow, Document context);

    /**
     * @return
     */
    public List<Document> getBooks();

    /**
     * @param action
     * @param task
     * @param resolution
     */
    void resolveTask(int action, Document task, Document resolution);

    /**
     * @return 
     * 
     */
    public List<Document> getApplications();

    /**
     * @param document
     * @param start
     * @param pagesize
     * @param user
     * @return
     */
    List<Document> getTasks(Document document, int start, int pagesize, IUser user);

    /**
     * @param nodeID
     * @param startpage
     * @param endpage
     * @param pagesize
     * @param table
     * @param limits
     * @param type
     * @param user
     * @return
     */
    List<Document> getTasks(String nodeID, int startpage, int endpage, int pagesize, String[] table, String limits,
	    String type, IUser user);

    /**
     * @param taskid
     * @param user
     * @return
     */
    Document getTask(String taskid, IUser user);

    /**
     * @param projectName
     * @param groupName
     * @param collectionName
     * @return
     * @throws Exception
     */
    String connect(String projectName, String groupName, String collectionName, IUser user) throws Exception;

    /**
     * @return
     */
    List<Document> getWorkFlows();

    /**
     * @param doc
     */
    public void updateWorkFlow(Document doc);


   public void updateFlow(Document doc);


}
