/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.db;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Supplier;

import javax.ejb.Asynchronous;
import javax.ejb.Remote;

import com.entitystream.monster.db.Document;

import com.entitystream.identiza.entity.resolve.match.MatchRecordInterface;
@Remote
public interface DBWorkerBatch {

	
	
	void setCommitSize(int commitSize);

	int getCommitSize();

	void shutdown(boolean forced) throws Exception;
	
		@Asynchronous
	Future<CommitItem> updateInternalNode(String id, Document values, boolean rematch);

	@Asynchronous
	Future<CommitItem> deleteInternalNode(String keyName, String keyValue, String id);
	
	@Asynchronous
	Future<CommitItem> addInternalNode(String keyName, String keyValue, Document values, String tableName) throws Exception;

	
	@Asynchronous
	Future<CommitItem> getInternalNode(String keyName, String keyValue);

    @Asynchronous
	Future releaseRecord(CommitItem item) throws InterruptedException;

    @Asynchronous
	Future commitQueue(ICommitBlock item);
	
    

	void createConnection(DBWorker dbWorker, String projectName, String groupName, int commitSize);

	void setJobID(String jobID);

	/**
	 * @param reltype
	 * @param string
	 * @param one
	 * @param two
	 * @param primaryTableName
	 * @param tableName
	 * @param values
	 * @param when
	 * @return
	 */
	Future<BaseRelationship> addInternalRelationship(String reltype, String string, String one, String two,
		String primaryTableName, String tableName, Map<String, Object> values, Date when);

	

	
	

	


	

	


	
	
	

}
