/**
 *
	MonsterDB - Collection Based Database with fuzzy matching
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.entitystream.identiza.entity.resolve.match.MatchCriteria;
import com.entitystream.identiza.entity.resolve.match.MatchRecordInterface;
import com.entitystream.identiza.entity.resolve.match.MatchTableInterface;
import com.entitystream.identiza.entity.resolve.metadata.ISchemaMeta;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumn;
import com.entitystream.identiza.entity.resolve.processing.IdentizaException;
import com.entitystream.identiza.entity.resolve.storage.Result;
import com.entitystream.identiza.entity.resolve.storage.Task;
import com.entitystream.identiza.metadata.IUser;
import com.entitystream.monster.db.Document;
import com.google.gson.JsonObject;

/**
 * @author roberthaynes
 *
 */
public interface IDBContainer {

    List<Document>  getTaskTypes();
    
    Map<String, Document> getMarketConnections(String groupName);

    boolean isValid() throws Exception;
    
     public List<Document> getCollections();

    void shutdown(boolean force) throws Exception;

    boolean isActive() throws Exception;


    int getCommitSize() throws Exception;

   
    Document addInternalNode(String keyName, String keyValue, Document values, String tabletype, boolean hasKeyChanged,
	    boolean isHistory, String username) throws Exception;


    ArrayList<Document> search(HashMap<String, String> matchC, String table) throws Exception;

    ArrayList<String> findShortestPath(ArrayList<String> validTables, String string, String string2, Date when)
	    throws Exception;

 
    Document deleteNode(String node, String survivedBy) throws Exception;

    ArrayList<String> getNodeRelationships(String node, String arg0, Date when) throws Exception;

    ArrayList<String> getNodeRelationships(String node, Date when) throws Exception;

    ArrayList<String> getNodeRelationships(String node, String reltype, String dir, Date when) throws Exception;

    Document createNodeRelationshipTo(String node, String table1, String other, String table2, String arg1,
	    Map<String, Object> values, Date when) throws Exception;

    Object deleteRel(String rel, Date when) throws Exception;

    String getRelEndNode(String rel, Date when) throws Exception;

    String[] getRelNodes(String rel, Date when) throws Exception;

    String getRelOtherNode(String rel, String node, Date when) throws Exception;

    String getRelStartNode(String rel, Date when) throws Exception;

    void clear(Collection<String> tableNames) throws Exception;

    DBWorkerBatch createBatchDB() throws Exception;

   
    long getNextId(String table);

    double getTableCount(String tableName);

   
    Document getRelProperties(String lng, Date when);

    Document addTask(String ID, Document values, String type, String nextAction);

  
    Iterator<Document> getLazyNodes(String tableName, int rowCount, Document where);

    void truncate(String tableName, Document filter);

    void addConnector(String connector, Document params, String groupName);

   
    DBWorker getDBWorker();


    ArrayList<Document> getRelationships(int start, int end, Document where);

    String getSchedule(String schema, String project);

    void putSchedule(Document job);

    List<Document> findRule(String rulePurpose, String query);

    String updateRule(Document doc);

    void addMessage(Document d);

    List<Document> getMessages(Date since);

    List<JsonObject> getSuspended(int page);

    List<Document> getScheduledJobs();

    Document getNode(String id);

    void checkIndexes();

    void releaseRecord(CommitItem iD);

    Document getJob(String jobID);

    void clearTableCount();

    List<String> getKeyList(String selectiveField, String selectiveValue, String indexName, int maxNodes);

    List<String> getRelNames();

    Collection<Document> getListeners(String type, String listenerID);

    Collection<Document> getListeners(String type, String listenerID, String schema, String project, String groupname);

    void addListener(String type, Document doc, String name, String projectName, String groupName);

    void deleteListener(Document doc, String name, String projectName, String groupName);

    Collection<Document> analyseBy(List<PurposeColumn> purposeColumns);

    Collection<Document> analyseBy(String tableName);

    Map<String, Integer> taskCount(String subject);



    void updateTask(String id, Document document);

    void deleteMessage(Document d);

    Document getRelationship(Document where, Date when);

    ISchemaMeta getSchDoc();
  
    void setSchDoc(ISchemaMeta schDoc);


    Collection<Result> findFuzzy(Document matchCriteria);
    Collection<Result> findFuzzy(String searchText);

    /**
     * @param tableName
     * @param keyName
     * @param keyValue
     * @param maxBucketSize
     * @return
     * @throws Exception
     */
    ArrayList<Document> getNodes(String tableName, String keyName, String keyValue, int maxBucketSize) throws Exception;

    /**
     * @param tableName
     * @param keyName
     * @param keyValue
     * @return
     * @throws Exception
     */
    Document getSingleNode(String tableName, String keyName, String keyValue) throws Exception;

    
    void resolveMerge(Document mr);


    void resolveLink(Document mr);


    void resolveEID(Document mr);

   
    void removeTask(Document d);

   
    Map<String, Document> find(String table, int start, int end, Document where, Document sort);

   
    List<Document> getTasks(String nodeid, int page, int endpage, int pgesize, String[] table, String limits,
	    String type);

 
    Document getTask(String taskid);

    /**
     * @param document
     * @return
     */
    Collection<Result> find(Document document);

    /**
     * @param storeName
     */
    void createStore(String storeName);

    /**
     * @return 
     * 
     */
    List<Document> getFlows();

    /**
     * @param flow
     * @param context
     * @return
     */
    String executeFlow(String flow, Document context);

    /**
     * @return
     */
    List<Document> getBooks();

 

    /**
     * @param taskid
     * @param mr
     * @param resolution
     * @param action
     */
    void resolve(String taskid, Document mr, Document resolution, int action);

    /**
     * @return
     */
    List<Document> getApplications();

    /**
     * @return
     */
    List<Document> getWorkFlows();

    /**
     * @param doc
     */
    void updateWorkFlow(Document doc);

    /**
     * @param doc
     */
    void updateFlow(Document doc);

}