/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.db;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import com.entitystream.monster.db.Document;

public interface IMasterDB {

	List<com.entitystream.monster.db.Document> getScheduledJobs();


	String getSchedule(String schema, String project, DBWorker baseDBWorker);

	void putSchedule(com.entitystream.monster.db.Document job);

	Collection<com.entitystream.monster.db.Document> getFileListeners(String type, String listenerID);

	Collection<com.entitystream.monster.db.Document> getFileListeners(String type, String listenerID,
			String schema, String project, String group);

	void addListener(String type, com.entitystream.monster.db.Document doc, String schemaName,
			String projectName, String groupName);

	void deleteListener(com.entitystream.monster.db.Document d, String schemaName, String projectName,
			String groupName);

	com.entitystream.monster.db.Document masterFindOne(String collection,
			com.entitystream.monster.db.Document filter);

	Iterator<com.entitystream.monster.db.Document> masterFind(String collection,
			com.entitystream.monster.db.Document filter);

	Iterator<com.entitystream.monster.db.Document> masterFind(String collection);

	void masterFindOneAndReplace(String collection, com.entitystream.monster.db.Document filter,
			com.entitystream.monster.db.Document replacement);

	void masterInsertOne(String collection, com.entitystream.monster.db.Document insert);

	void masterDeleteMany(String collection, com.entitystream.monster.db.Document finder);

	void masterFindAndDelete(String collection, com.entitystream.monster.db.Document filter);

	void masterUpdateOne(String collection, com.entitystream.monster.db.Document filter,
			com.entitystream.monster.db.Document replacement);

	String masterFindRule(String rulePurpose, String query);

	String updateRule(com.entitystream.monster.db.Document rule);

}