
/**
 *
	Identiza - Fuzzy matching Libraries

    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.db;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.entitystream.identiza.entity.resolve.metadata.PurposeColumnMap;
import com.entitystream.identiza.entity.resolve.types.Standardized;
import com.entitystream.identiza.entity.resolve.types.StandardizedSerialized;
import com.entitystream.identiza.wordlist.WordList;
import com.entitystream.monster.db.Document;

/**
 * @author roberthaynes
 *
 */
public interface INode {

     String getId();

    Iterator<IRelationship> getRelationships(String arg0, Date when) throws Exception;

    Iterator<IRelationship> getRelationships(Date when) throws Exception;

    Iterator<IRelationship> getRelationships(String reltype, String dir, Date when) throws Exception;

    Object getProperty(String arg0);

    IRelationship createRelationshipTo(INode arg0, String arg1, Date when,
	    Map<String, Object> values) throws Exception;

    Map<String, Object> getPropertyValues() throws Exception;

    void setDB(IDBContainer db2);

    void setProperties(Document vals);

    Document getDocument();

    ArrayList<String> getProperties(List<String> cols);

    String getTableName();

    void setID(String id);

    String toJSON() throws Exception;

    public static Object[] getWords(Document node, List<PurposeColumnMap> map, WordList anon, Date when) throws Exception{
	ArrayList<ArrayList<String>> resmultirecs = new ArrayList<ArrayList<String>>();
	ArrayList<ArrayList<String>> resonerec = new ArrayList<ArrayList<String>>();
	StringBuilder allWords = new StringBuilder();
	//initialise the arraylist
	int largest=0;
	if (map!=null){
	    for (PurposeColumnMap pcm : map){
		largest = Math.max(pcm.getColumnOrder(),largest);				
	    }
	    for (int t=0; t<largest; t++)			
		resonerec.add(new ArrayList<String>());
	    //loop thru the maps in column order - construct the values
	    for (PurposeColumnMap pcm : map){		
		String val = Document.objectToString(node.getProjection(pcm.getTableColumn()));
		allWords.append(val+" ");
		ArrayList<String> resinner = new ArrayList<String>();
		if (val !=null){
		    String[] strs = WordList.split(val);
		    for (String str : strs){
			str=WordList.clean(str);
			if (str.length()>0){
			    if (anon==null)
				resinner.add(str);
			    else 
				if (anon.isUsefulForComparison(str,0))
				    resinner.add(str);
			}
		    }
		}
		//append to the first item 
		int o=pcm.getColumnOrder();
		if (o>1)
		    o=o-1;
		resonerec.add(o,resinner);

	    }
	}
	if (resmultirecs.size()>0){
	    ArrayList<ArrayList<String>> ret = new ArrayList<ArrayList<String>>();
	    for (ArrayList<String> outter : resmultirecs){
		ret.add(compressInitials(outter));   
	    }
	    return new Object[]{ret, allWords.toString().trim()};
	}
	else
	{
	    //compress into one arraylist
	    ArrayList<String> compress = new ArrayList<String>();
	    for (ArrayList<String> inner : resonerec){
		compress.addAll(compressInitials(inner));
	    }
	    ArrayList<ArrayList<String>> retval = (new ArrayList<ArrayList<String>>());
	    retval.add(compress);
	    return new Object[]{retval, allWords.toString().trim()};
	}
    }

    public static Object[] getWords(INode node, List<PurposeColumnMap> map, WordList anon, Date when) throws Exception{

	return getWords(node.getDocument(), map, anon, when);

    }

    public static ArrayList<String> compressInitials(ArrayList<String> in){
	String accumulate="";
	ArrayList<String> out = new ArrayList<String>();
	if (in.size()>1){
	    for (String word : in){
		if (word.trim().length()==1){
		    accumulate+=word.trim();
		} else {
		    if (accumulate.length()>0){
			out.add(accumulate);
			accumulate="";
		    }
		    out.add(word);
		}
	    }
	    if (accumulate.length()>0)
		out.add(accumulate);
	} else return in;
	return out;
    }

    
    public static List<Document> serialize(List<Standardized> standards) {
	List<Document> list = new ArrayList<Document>();
	try {
		for (Standardized std : standards)
			list.add(std.toDocument());
	} catch (Exception e) {
		e.printStackTrace();
	}

	return list;
    }

    public static List<Standardized> deserialise(List<Document> bsonlist, Class<? extends Standardized> procClass) {
	List<Standardized> ret = new ArrayList<Standardized>();
	try {
		for (Document d : bsonlist){
			Standardized std = StandardizedSerialized.fromDocument(d);
			//if (std.getClass().isAssignableFrom(procClass))
			ret.add(std);
		}
	} catch (Exception e) {
		return null;
	}
	return ret;
    }

    /**
     * @param tableColumn
     * @param currentValue
     * @return 
     */
    Object setProperty(String tableColumn, Object currentValue);

    /**
     * @param string
     * @return
     */
    boolean hasProperty(String string);

}