/**
 *
	Identiza - Fuzzy matching Libraries

    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.entitystream.identiza.entity.resolve.processing.IdentizaException;
import com.entitystream.monster.db.Document;

public class Relationship implements Serializable, IRelationship {
    private String id;
    private Date when;
    private Document properties;
    private List<INode> nodes;

    public Relationship(IDBContainer db, Document doc, Date when) throws Exception {
	if (doc == null)
	    throw new IdentizaException("Invalid Node");
	this.id = doc.getString("_id");
	if (id == null)
	    throw new IdentizaException("Invalid Node");
	this.properties=doc;

	this.when=when;
	nodes= new ArrayList<INode>();
	
	nodes.add((new Node(db, db.getNode((String) properties.getString("fromCol")))));
	nodes.add((new Node(db, db.getNode((String) properties.getString("toCol")))));
	
    }




    /* (non-Javadoc)
     * @see com.entitystream.identiza.db.IRelationship#getId()
     */
    @Override
    public String getId() {
	return id;
    }

    /* (non-Javadoc)
     * @see com.entitystream.identiza.db.IRelationship#getNodes()
     */
    @Override
    public List<INode> getNodes() {
	return nodes;

    }

    /* (non-Javadoc)
     * @see com.entitystream.identiza.db.IRelationship#getOtherNode(com.entitystream.identiza.db.Node)
     */
    @Override
    public INode getOtherNode(INode node) {
	for (INode thisNode : getNodes())
	    if (!thisNode.equals(node))
		return thisNode;


	return null;

    }


    /* (non-Javadoc)
     * @see com.entitystream.identiza.db.IRelationship#setLastUpdate(java.util.Date)
     */
    @Override
    public void setLastUpdate(Date date) {
	this.when=date;

    }




    /* (non-Javadoc)
     * @see com.entitystream.identiza.db.IRelationship#getType()
     */
    @Override
    public String getType() throws Exception {

	return properties.getString("reltype");
    }




    /* (non-Javadoc)
     * @see com.entitystream.identiza.db.IRelationship#getProperties()
     */
    @Override
    public Document getProperties() {

	return properties;
    }




    /* (non-Javadoc)
     * @see com.entitystream.identiza.db.IRelationship#getEndNode()
     */
    @Override
    public INode getEndNode() {
	if (nodes.size()>0)
	    return nodes.get(nodes.size()-1);
	else return null;
    }




    /* (non-Javadoc)
     * @see com.entitystream.identiza.db.IRelationship#setProperties(com.entitystream.monster.db.Document)
     */
    @Override
    public void setProperties(Document values) {
	properties.putAll(values);
    }
}
