/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.db;

public interface WorkTypes {
	public static final int DELETE = -1;
	public static final int ADD = 1;
	public static final int MATCH = 2;
	public static final int MERGE = 3;
	public static final int SORT = 4;
	public static final int LINK = 5;
	public static final int TASK = 6;
	public static final int EID = 7;
	public static final int IGNORE = 0;
	public static final int PUBLISH = 8;
	public static final int ACCEPT = 9;
	
	public static String toString(int action) {
	    if (action==DELETE)
	      return "Delete";
	    if (action==ADD)
		      return "ADD";
	    if (action==MATCH)
		      return "MATCH";
	    if (action==MERGE)
		      return "MERGE";
	    if (action==SORT)
		      return "SORT";
	    if (action==LINK)
		      return "LINK";
	    if (action==TASK)
		      return "TASK";
	    if (action==EID)
		      return "EID";
	    if (action==PUBLISH)
		      return "PUBLISH";
	    if (action==ACCEPT)
		      return "ACCEPT";
	    return "IGNORE";
	}

	/**
	 * @param action
	 * @return
	 */
	public static int parse(String action) {
	    if (action.equalsIgnoreCase("Delete"))
		return -1;
	    else if (action.equalsIgnoreCase("Add"))
		return 1;
	    else if (action.equalsIgnoreCase("Match"))
		return 2;
	    else if (action.equalsIgnoreCase("Merge"))
		return 3;
	    else if (action.equalsIgnoreCase("Sort"))
		return 4;
	    else if (action.equalsIgnoreCase("Link"))
		return 5;
	    else if (action.equalsIgnoreCase("Task"))
		return 6;
	    else if (action.equalsIgnoreCase("EID"))
		return 7;
	    else if (action.equalsIgnoreCase("Publish"))
		return 8;
	    else if (action.equalsIgnoreCase("Accept"))
		return 9;
	    else if (action.equalsIgnoreCase("Approve"))//wf
		return 10;
	    else if (action.equalsIgnoreCase("Reject"))//wf
		return 12;
	    else if (action.equalsIgnoreCase("Return"))//wf
		return 14;
	    else if (action.equalsIgnoreCase("Escalate"))//wf
		return 18;
	    else if (action.equalsIgnoreCase("Restart"))//wf
		return 26;
	    else if (action.equalsIgnoreCase("Amendment"))//wf
		return 27;
	    else if (action.equalsIgnoreCase("Review"))//wf
		return 28;
	    else return 0;  //ignore
	}

	
}
