/**
 *
	MonsterDB - Collection Based Database with fuzzy matching

    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.extract;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

/**
 * @author roberthaynes
 *
 */
public class MagentoReader { 
    Iterator<Element> catElems= null;
    Iterator<Element> prodElems= null;
    public MagentoReader(File filename) throws IOException {
	Document doc = Jsoup.parse(filename,"UTF-8");
	catElems = doc.body().select(".nav-item > a > span").iterator();
	prodElems = doc.body().select(".item").iterator();
	//System.out.println(doc.body().getAllElements().toString());
    }

    public MagentoReader(String url) throws IOException {
	Document doc = Jsoup.connect(url).get();
	catElems = doc.body().select(".nav-item > a").iterator();
	prodElems = doc.body().select(".item").iterator();
    }

    public static void main(String[] args) {
	try {
	    //MagentoReader mr = new MagentoReader(new File("/Users/roberthaynes/Documents/temp/wine.html"));
	    MagentoReader mr = new MagentoReader("https://www.lovebrewing.co.uk/wine/wine-kits/");

	    List<JsonObject> cats = new ArrayList<JsonObject>();
	    JsonObject category = mr.readCategory();
	    while (category!=null) {
		System.out.println(category);
		category = mr.readCategory();
		cats.add(category);
		//category=null;
	    }

	    List<JsonObject> prods = new ArrayList<JsonObject>();
	    for (JsonObject cat : cats) {
		String link = cat.get("Link").getAsString();
		MagentoReader mr2 = new MagentoReader(link);
		JsonObject product = mr2.readProduct();
		while (product!=null) {
		    System.out.println(product);
		    product = mr.readCategory();
		    if (product!=null) {
			product.addProperty("Category", cat.get("Name").getAsString());
			prods.add(product);
		    }
		    // product=null;
		}
	    }
	} catch (IOException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	}
    }

    /**
     * @return
     */
    private JsonObject readCategory() {
	if (catElems.hasNext()) {
	    Element element= catElems.next();
	    JsonObject jo = new JsonObject();
	    jo.addProperty("Link", element.attr("href"));
	    jo.addProperty("Name", element.select("span").first().text());
	    return jo;
	}
	return null;

    }


    private JsonObject readProduct() {
	if (prodElems.hasNext()) {
	    Element element= prodElems.next();
	    JsonObject jo = new JsonObject();
	    jo.addProperty("Name", element.select(".product-name > a").text());
	    Element img = element.select(".product-image-wrapper > a > img").first();
	    jo.addProperty("Image", img.attr("src"));
	    jo.addProperty("ImageAltText", img.attr("alt"));
	    jo.addProperty("ID", img.attr("id"));
	    JsonArray priceArray  = new JsonArray();
	    jo.add("Prices", priceArray);

	    Elements prices = element.select(".price-box");
	    for (Element price : prices) {
		JsonObject pr = new JsonObject();
		String label=price.select(".price-label").text();
		if (label==null || label.length()==0)
		    label="Regular";
		pr.addProperty("Name", label);
		pr.addProperty("Price", price.select(".price").text());
		priceArray.add(pr);
	    }
	    return jo;
	}
	return null;

    }
}
