/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.match;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.entitystream.monster.db.Document;
import com.entitystream.identiza.db.INode;
import com.entitystream.identiza.db.Node;
import com.entitystream.identiza.entity.resolve.storage.Record;
import com.entitystream.identiza.entity.resolve.storage.RecordInterface;

public class GoldenRecord implements Serializable {
	private Document golden = null;
	private List<Document> goldennodes = new ArrayList<Document>();
	
	public Document getDocument() {
		return golden;
	}
	public GoldenRecord( long eid, Collection<INode> group, double score, String label, MatchSchemaInterface sch ) {
		try {
			for (INode baseNode : group){
				//for each concept
				if (golden==null){
				    if (eid!=-1)
					golden = new Document("EID", eid);
				    else
					golden = new Document("_id", baseNode.getId());
				}

				goldennodes.add(baseNode.getDocument());

				RecordInterface r = new Record(sch, baseNode);
				sch.standardise(r);
				Document std = r.getBaseNode().getDocument();
				if (std!=null && std.containsKey("standardized")){
					Document stds = std.getAsDocument("standardized");
					for (String key : stds.keyString()){
						String existing = (String) golden.get(key);
						if (existing==null) {
							StringBuilder phrase = new StringBuilder();
							for (Object stdDocO : (List)stds.get(key)){
								Document stdDoc = (Document)stdDocO;
								List<String> words = (List)stdDoc.get("originalWords");
								if (phrase.length()>0)
									phrase.append("/ ");
								for (String word : words){
									phrase.append(word+" ");
								}
								phrase.toString().trim();
							}
							golden.append(key, phrase.toString());
						}
					}
				}


			}
			if (golden==null)
				golden=new Document();
			golden.append("data", new Document("nodes", goldennodes)).append("label", label).append("score", score);

		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
}
