/*******************************************************************************
 * Copyright notice
 * 
 * This source code is copyright of Robert James Haynes - (c) 2010, 2011. All rights reserved.
 * 
 * Any redistribution, reproduction or decompilation of part or all of the code in any form is prohibited 
 * 
 * You may not, except with our express written permission, distribute or commercially exploit the content. Nor may you transmit it or store it in or display it on any website or other form of electronic retrieval system.
 ******************************************************************************/
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.match;

import java.io.Serializable;

public class Match implements Serializable{
	private String id;
	private String table;
	private int score;
	private int origWordPos=-1;
	private int candWordPos=-1;
	private int numMatchRecWords=-1;
	private String reason="UNMATCHED";
	private String token;
	public Match(String id, String table, int score, int origPos, int candPos, int numMatchRecWords, String reason, String token){
		this.id=id;
		this.table=table;
		this.score=score;
		this.origWordPos=origPos;     //original wordpos
		this.candWordPos=candPos; //candidate wordpos
		this.reason=reason;
		this.setToken(token);
		this.setNumMatchRecWords(numMatchRecWords);
	}
	public Match(String id, String table, int score, String reason, String token){
		this.id=id;
		this.table=table;
		this.score=score;
		this.reason=reason;
		this.setToken(token);
		this.setNumMatchRecWords(numMatchRecWords);
	}

	public void setOrigWordPos(int pos){
		origWordPos=pos;
	}
	
	public int getOrigWordPos(){
		return origWordPos;
	}
	public void setId(String id) {
		this.id = id;
	}
	public String getId() {
		return id;
	}
	public void setTable(String table) {
		this.table = table;
	}
	public String getTable() {
		return table;
	}
	public void setScore(int score) {
		this.score = score;
	}
	public int getScore() {
		return score;
	}
	public void setCandWordpos(int wordpos) {
		this.candWordPos = wordpos;
	}
	public int getCandWordpos() {
		return candWordPos;
	}
	public void setReason(String reason) {
		this.reason = reason;
	}
	public String getReason() {
		return reason;
	}
	public void setNumMatchRecWords(int numMatchRecWords) {
		this.numMatchRecWords = numMatchRecWords;
	}
	public int getNumMatchRecWords() {
		return numMatchRecWords;
	}
	public void setToken(String token) {
		this.token = token;
	}
	public String getToken() {
		return token;
	}
}
