/*******************************************************************************
 * Copyright notice
 * 
 * This source code is copyright of Robert James Haynes - (c) 2010, 2011. All rights reserved.
 * 
 * Any redistribution, reproduction or decompilation of part or all of the code in any form is prohibited 
 * 
 * You may not, except with our express written permission, distribute or commercially exploit the content. Nor may you transmit it or store it in or display it on any website or other form of electronic retrieval system.
 ******************************************************************************/
/**
 *
	Identiza - Fuzzy matching Libraries

    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.match;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import com.entitystream.identiza.entity.resolve.storage.RecordInterface;
import com.entitystream.identiza.entity.resolve.storage.RecordValue;
import com.entitystream.identiza.entity.resolve.storage.RecordValues;

public class MatchCriteria implements Serializable{

    private HashMap<String, String> colsvals = new HashMap<String, String>();
    private String tableName;
    private String freeText;

    public MatchCriteria(String item) throws Exception{


	if (item!=null){				
	    if (item.contains(":") && !item.contains("_search:")){ //structured
		item.replaceAll(":","").replaceAll("=", ": ");
		tableName = item.substring(0, item.indexOf("("));


		int end=item.length();
		if (item.indexOf(")")>-1)
		    end=item.indexOf(")");
		String rest = item.substring(item.indexOf("(")+1, end);
		String[] bits = rest.split(";");
		for (String bit : bits){
		    if (bit.indexOf(":")!=-1){
			String column = bit.substring(0,bit.indexOf(":")).trim();
			String value = bit.substring(bit.indexOf(":")+1).trim();
			addCriteria(column, value);
		    }
		}
	    }

	    else //freetext or tablename
	    {
		if (item.contains("_search:")) {
		    tableName=item.substring(0,item.indexOf("_search:")-1);
		    freeText=item.substring(item.indexOf("_search:")+8).trim();
		    if (freeText.endsWith(")"))
			freeText=freeText.substring(0,freeText.length()-1);
		} else tableName=item;
	    }
	}
    }





    public MatchCriteria(RecordValues recordValues, String tableName, MatchSchemaInterface schema) throws Exception{
	this.tableName=tableName;
	for (RecordValue rv : recordValues.getValues()){
	    addCriteria(rv.getKey(), rv.getValue());
	}
    }

    public MatchCriteria(RecordInterface record, MatchSchemaInterface schema) throws Exception{
	this.tableName=record.getTableName();
	ConcurrentHashMap<String, Object> vals = record.getValues();
	for (String key : vals.keySet()){
	    addCriteria(key, vals.get(key).toString());
	}
    }

    public String toString(){
	String res = tableName + "(";
	for (String col: colsvals.keySet())
	    res = res + col + ":" + colsvals.get(col) + ";";
	if (hasFreeText())
	    res+="\"" + freeText + "\"";
	if (res.endsWith(";"))
	    res = res.substring(0, res.length()-1);
	res += ")";
	return res;
    }



    public boolean hasData(){
	return colsvals.size()>0;
    }

    public void addCriteria(String tableColumn, String val){
	colsvals.put(tableColumn, val);
    }


    public MatchCriteria addFreeText(String val) {
	this.freeText = val;
	return this;
    }

    public String getFreeText(){
	if (freeText!=null)
	    return freeText.trim();
	else return null;
    }


    public String getValue(String colname){
	for (String col: colsvals.keySet()){
	    if (col.equalsIgnoreCase(colname)){
		return colsvals.get(col);
	    }
	}
	return null;
    }
    public void setTableName(String tableName) {
	this.tableName = tableName;
    }
    public String getTableName() {
	return tableName;
    }
    public int size() {
	// TODO Auto-generated method stub
	return colsvals.size();
    }

    public void reset() {
	// TODO Auto-generated method stub
	colsvals = new HashMap<String, String>();		
    }


    public boolean hasFreeText() {
	return freeText!=null && freeText.length()>0;
    }

    public HashMap<String, String> getValues() {
	// TODO Auto-generated method stub
	return colsvals;
    }

    public Map<String, Object> getMap(){
	HashMap<String, Object> vals = new HashMap<String, Object>();
	for (String col : colsvals.keySet()){
	    vals.put(col, colsvals.get(col));
	}
	return vals;
    }
}
