/*******************************************************************************
 * Copyright notice
 * 
 * This source code is copyright of Robert James Haynes - (c) 2010, 2011. All rights reserved.
 * 
 * Any redistribution, reproduction or decompilation of part or all of the code in any form is prohibited 
 * 
 * You may not, except with our express written permission, distribute or commercially exploit the content. Nor may you transmit it or store it in or display it on any website or other form of electronic retrieval system.
 ******************************************************************************/
package com.entitystream.identiza.entity.resolve.match;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import java.util.logging.Logger;

import com.entitystream.monster.db.Document;
import com.entitystream.identiza.db.IDBContainer;
import com.entitystream.identiza.db.INode;
import com.entitystream.identiza.db.Node;
import com.entitystream.identiza.entity.resolve.processing.IdentizaException;
import com.entitystream.identiza.entity.resolve.storage.Record;
import com.entitystream.identiza.entity.resolve.storage.RecordInterface;
import com.entitystream.identiza.entity.resolve.metadata.PurposeColumnMap;
import com.entitystream.identiza.entity.resolve.metadata.IIndex;
import com.entitystream.identiza.entity.resolve.metadata.ISchemaMeta;
import com.entitystream.identiza.entity.resolve.metadata.Table;
import com.entitystream.identiza.entity.resolve.types.MatchBase;
import com.entitystream.identiza.entity.resolve.types.MatchProcDefinition;
import com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface;
import com.entitystream.identiza.entity.resolve.types.MatchProcInterface;
import com.entitystream.identiza.wordlist.WordList;

public class MatchIndex extends Indexable implements Serializable, MatchIndexInterface {
	private String domainName;
	private HashMap<String, MatchProcInterface> matchProcs = new HashMap<String, MatchProcInterface>();
	private Logger logger = Logger.getLogger("com.entitystream.identiza");
	private IDBContainer db3;
	private MatchSchemaInterface matchSchema = null;
	private boolean isSearch = true;
	private boolean isMatch = true;
	public String REF_TOKEN = null;
	private boolean isTextIndex = false;
	private String instance;
	Collection<MatchProcDefinitionInterface> matchprocDefns;
	private int keyThreshold;
	private boolean isExactIndex;
	private ArrayList<String> matchProcKeys = new ArrayList<String>();
	private String purposeName;

	public MatchIndex(IIndex index, MatchSchemaInterface schema) {
		this.domainName=index.getIndexName();
		this.isExactIndex=index.isExactIndex();
		this.isMatch=index.isMatch();
		this.isSearch=index.isSearch();
		this.keyThreshold=index.getKeyThreshold();
		this.matchSchema=schema;
		this.matchprocDefns = matchSchema.getSchDoc().getMatchProcs(domainName, instance, matchSchema.getGroupName());
		this.setPurposeName(index.getPurposeName());
		try {

			if (logger == null)
				logger = Logger.getLogger("com.entitystream.identiza");


			if (matchprocDefns.size() > 0) {
				java.util.Iterator i = matchprocDefns.iterator();
				while (i.hasNext()) {
					MatchProcDefinitionInterface def = ((MatchProcDefinitionInterface) i.next());
					String defname = def.getProcName() + "";
					// matchProcStore.put(defname, def);

					MatchBase matchP = null;
					String name = def.getClassName();
					if (!name.contains("."))
						name = "com.entitystream.identiza.entity.resolve.types." + name;
					Class clazz = Class.forName(name);
					Constructor cons = clazz.getConstructor(String.class,
							int.class,
							int.class);
					matchP = (MatchBase) cons.newInstance(null,
							def.getMinWidth(), def.getMaxWidth());
				
					matchP.init(null);
					matchP.setRuleSet(def.getRuleSet());

					matchP.setMandatory(def.getIsMandatory());
					//hashMaps do not keep the keys in order, arraylists do
					matchProcKeys.add(defname);
					matchProcs.put(defname, matchP);

					// whole index becomes text index if one matchproc is
					if (matchP.isTextIndex())
						isTextIndex = true;
				}
			}

		} catch (Exception e) {
			e.printStackTrace();
			logger.severe(
					"Match Index could not be initialised, see previous error " + e.toString());
		}
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.match.MatchIndexInterface#isTextIndex()
	 */
	@Override
	public boolean isTextIndex() {
		return isTextIndex;
	}


	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.match.MatchIndexInterface#setDomainName(java.lang.String)
	 */
	@Override
	public void setDomainName(String columnName) {
		this.domainName = columnName;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.match.MatchIndexInterface#getDomainName()
	 */
	@Override
	public String getDomainName() {
		return domainName;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.match.MatchIndexInterface#setIsMatch(boolean)
	 */
	@Override
	public void setIsMatch(boolean ismatch) {
		this.isMatch = ismatch;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.match.MatchIndexInterface#setIsSearch(boolean)
	 */
	@Override
	public void setIsSearch(boolean issearch) {
		this.isSearch = issearch;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.match.MatchIndexInterface#isSearch()
	 */
	@Override
	public boolean isSearch() {
		return isSearch;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.match.MatchIndexInterface#isMatch()
	 */
	@Override
	public boolean isMatch() {
		return isMatch;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.match.MatchIndexInterface#getKeyThresholdDep()
	 */
	@Override
	public int getKeyThresholdDep() {
		// TODO Auto-generated method stub
		return keyThreshold;
	}

	

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.match.MatchIndexInterface#getMatchProc(java.lang.String)
	 */
	@Override
	public MatchProcInterface getMatchProc(String name) {
		return matchProcs.get(name);
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.match.MatchIndexInterface#getMatchProcs()
	 */
	@Override
	public ArrayList<String> getMatchProcs() {
		return matchProcKeys;
	}
	
	
	


	Map<String, List<String>> cachedMappedColumnNames = new HashMap<String, List<String>>();
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.match.MatchIndexInterface#getMappedColumnNames(java.lang.String)
	 */
	@Override
	public List<String> getMappedColumnNames(String table) {
		//
		List<String> indexCols = cachedMappedColumnNames.get(table);
		if (indexCols== null || indexCols.size()==0)
			indexCols=new ArrayList<String>();
		else
			return indexCols;

		Iterator<MatchProcDefinitionInterface> enumr = matchprocDefns.iterator();
		while (enumr.hasNext()) {
			MatchProcDefinitionInterface procname = (MatchProcDefinitionInterface) enumr.next();
			for (String _col :  matchSchema.getSchDoc().getTableColumnMaps(procname.getPurposeName(), table))
				if (_col!=null)
					if (!indexCols.contains(_col))
					   indexCols.add(_col);
		}
		cachedMappedColumnNames.put(table, indexCols);
		return indexCols;
	}
	
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.match.MatchIndexInterface#getMappedColumnNames(java.lang.String, java.lang.String)
	 */
	@Override
	public List<String> getMappedColumnNames(String table, String procName) {
		//
		List<String> indexCols = cachedMappedColumnNames.get(table+":"+procName);
		if (indexCols== null || indexCols.size()==0)
			indexCols=new ArrayList<String>();
		else
			return indexCols;

		Iterator<MatchProcDefinitionInterface> enumr = matchprocDefns.iterator();
		while (enumr.hasNext()) {
			MatchProcDefinitionInterface procname = (MatchProcDefinitionInterface) enumr.next();
			if (procName.equalsIgnoreCase(procname.getProcName()))
			   for (PurposeColumnMap _pcm :  matchSchema.getSchDoc().getTablePurposeColumnMaps(table))
				  if (_pcm!=null){
					  if ((_pcm.getPurposeName()+"_"+_pcm.getPurposeColumn()).equalsIgnoreCase(procName)){
					     if (!indexCols.contains(_pcm.getTableColumn()))
					        indexCols.add(_pcm.getTableColumn());
					  }
				  }
		}
		cachedMappedColumnNames.put(table, indexCols);
		return indexCols;
	}

	
	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.match.MatchIndexInterface#setIsText(boolean)
	 */
	@Override
	public void setIsText(boolean isContent) {
		this.isTextIndex = isContent;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.match.MatchIndexInterface#setKeyThreshold(int)
	 */
	@Override
	public void setKeyThreshold(int thresh) {
		this.keyThreshold = thresh;

	}


	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.match.MatchIndexInterface#isExactIndex()
	 */
	@Override
	public boolean isExactIndex() {
		return isExactIndex;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.match.MatchIndexInterface#setExactIndex(boolean)
	 */
	@Override
	public void setExactIndex(boolean isExactIndex) {
		this.isExactIndex = isExactIndex;

	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.match.MatchIndexInterface#getInstance()
	 */
	@Override
	public Object getInstance() {
		return instance;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.match.MatchIndexInterface#setInstance(java.lang.String)
	 */
	@Override
	public void setInstance(String instance) {
		this.instance = instance;
	}


	private IDBContainer getDB() throws Exception{
		if (db3==null)
			db3=this.matchSchema.getDb();
		return db3;
	}


	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.match.MatchIndexInterface#getKeyThreshold()
	 */
	@Override
	public int getKeyThreshold() {
		// TODO Auto-generated method stub
		return keyThreshold;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.match.MatchIndexInterface#setPurposeName(java.lang.String)
	 */
	@Override
	public void setPurposeName(String purposeName) {
		this.purposeName=purposeName;
	}

	/* (non-Javadoc)
	 * @see com.entitystream.identiza.entity.resolve.match.MatchIndexInterface#getPurposeName()
	 */
	@Override
	public String getPurposeName() {
		return purposeName;
	}

}
