/**
 *
	MonsterDB - Collection Based Database with fuzzy matching
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.match;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import com.entitystream.identiza.db.INode;
import com.entitystream.identiza.entity.resolve.storage.RecordInterface;
import com.entitystream.identiza.entity.resolve.types.MatchProcInterface;

/**
 * @author roberthaynes
 *
 */
public interface MatchIndexInterface {

    boolean isTextIndex();

    void setDomainName(String columnName);

    String getDomainName();

    void setIsMatch(boolean ismatch);

    void setIsSearch(boolean issearch);

    boolean isSearch();

    boolean isMatch();

    int getKeyThresholdDep();

   
    MatchProcInterface getMatchProc(String name);

    ArrayList<String> getMatchProcs();

  
    List<String> getMappedColumnNames(String table);

    List<String> getMappedColumnNames(String table, String procName);

   
    void setIsText(boolean isContent);

    void setKeyThreshold(int thresh);

    boolean isExactIndex();

    void setExactIndex(boolean isExactIndex);

    Object getInstance();

    void setInstance(String instance);

    int getKeyThreshold();

    void setPurposeName(String purposeName);

    String getPurposeName();

}