/**
 *
	MonsterDB - Collection Based Database with fuzzy matching
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.match;

import java.util.Date;

import com.entitystream.identiza.db.INode;
import com.entitystream.identiza.entity.resolve.metadata.IRule;
import com.entitystream.identiza.entity.resolve.storage.Record;
import com.entitystream.identiza.entity.resolve.storage.RecordInterface;
import com.entitystream.monster.db.Document;
import com.google.gson.JsonObject;

/**
 * @author roberthaynes
 *
 */
public interface MatchRecordInterface {

   
    String getRecordID();

    INode getBaseNode() throws Exception;

    INode getNode() throws Exception;

    RecordInterface getRecord(MatchSchemaInterface schema) throws Exception;

    void setRecord(RecordInterface record);

    String getBaseRecordID();

    RecordInterface getBaseRecord(MatchSchemaInterface schema) throws Exception;

    void setBaseRecord(RecordInterface record);

    double getScore();

    void setScore(double score);

    IRule getRule();

    String getAction();

    String getActionText();

    void setActionText(String actionText);

    void setAction(String action);

    String getBaseRecordTableName();

    String getRecordTableName();

    String getBaseRecordKey();

    String getRecordKey();

    String getAcceptance();

    String getBaserecordsystem();

    void setBaserecordsystem(String baserecordsystem);

    String getRecordsystem();

    void setRecordsystem(String recordsystem);

    Date getWhen();

    void setWhen(Date when);

    long getBaseRecordEID();

    long getRecordEID();

    JsonObject toJSON();

    Document toDocument();

    int getType();

    String getTaskId();

}