/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.match;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.entitystream.monster.db.Document;
import com.entitystream.identiza.db.IDBContainer;
import com.entitystream.identiza.db.WorkTypes;
import com.entitystream.identiza.entity.resolve.metadata.IPurpose;
import com.entitystream.identiza.entity.resolve.metadata.ISchemaMeta;
import com.entitystream.identiza.entity.resolve.metadata.ITable;
import com.entitystream.identiza.entity.resolve.storage.Record;
import com.entitystream.identiza.entity.resolve.storage.RecordInterface;
import com.entitystream.identiza.metadata.IUser;
import com.entitystream.identiza.userexits.JobObject;
import com.entitystream.identiza.userexits.MergeObject;
import com.entitystream.identiza.userexits.MessageObject;
import com.entitystream.identiza.userexits.PreTaskObject;
import com.entitystream.identiza.userexits.TimerObject;
import com.entitystream.identiza.userexits.UpdateObject;


public interface MatchSchemaInterface {

	
	
	
	public ITable getTable(String tableName);

	public MatchTableInterface getMatchTable(String name) throws Exception;

	public Collection<IPurpose> getPurposes();

	public IPurpose getPurpose(String purposeName, String groupName);

	
	public ISchemaMeta getSchDoc();

	public List<String> getTableNames(String prefix);

	public String getProjectName();

	public java.lang.String getGroupName();

	
	public int getThreads();

	public int getCommitSize();

	public boolean equals(String projectName2,
			String groupName2);

	public IDBContainer getDb() throws Exception;

	public String getNodeName();

	
		public ArrayList<MatchIndexInterface> getMatchIndexes();


	public void setSchDoc(ISchemaMeta schDoc);


	

	MatchRuleInterface getMatchRule(String hashKey, int index);


	void clearRules();

	
		
	public static Map<String, MatchRecordInterface> matchScore(
			String key,
			RecordInterface comparitor,
			RecordInterface base,
			boolean forSearch,
			boolean asContent, 
			boolean matchScoring) throws Exception {
		long stime=System.currentTimeMillis();
		Map<String, MatchRecordInterface> results=new HashMap<String, MatchRecordInterface>();				

		String endKey=key.substring(key.lastIndexOf(":")+1);
		boolean foundOnKey=false;
		MatchRecordInterface match=null;
		if (forSearch){
			if (base.getPkey()!=null){
				if (base.getPkey().equalsIgnoreCase(endKey)){
					match = new MatchRecord(comparitor, null, 100.0, null,
							"Primary Key Match", "");
					foundOnKey=true;
				}
			}
			if (base.getValue("EID")!=null){
				if (base.getValue("EID").equalsIgnoreCase(comparitor.getValue("EID"))){
					match = new MatchRecord(comparitor, null, 100.0, null,
							"Primary Key Match", "");
					foundOnKey=true;
				}
			}
			for (Document xref : comparitor.getXref()){

				if (xref.getString(comparitor.getKeyField()).equalsIgnoreCase(endKey) ||
						xref.getString("EID").equalsIgnoreCase(base.getValue("EID"))	){
					foundOnKey=true; 
					match = new MatchRecord(comparitor, null, 100.0, null,
							"XREF Match", "");
					break;
				}
			}
			if (asContent) {
				foundOnKey=true; 
				match = new MatchRecord(comparitor, null, 100.0, null,
						"TAG Match", "");
			}
		}

		if (!foundOnKey){
			{
				match = base.calculateScore(comparitor, forSearch, true, asContent,matchScoring);
				if (comparitor.isHistory() && match!=null && match.getScore()<100){
					//check the history records for a better match
					int count=0;
					for (RecordInterface comparitorHist : comparitor.getHistoryRecords()){
						MatchRecordInterface match2 = base.calculateScore(comparitorHist, forSearch, true, asContent, matchScoring);
						if (match2!=null && match2.getScore()>match.getScore())
							match=match2;
						count++;
						if (count>5)
							break;
					}
				}
			}
		}

		if (match!=null){
			double _width=-1d;
			if (!forSearch)
				_width=match.getRule().getLowScore();
			if (match.getScore() >= _width && match.getScore()>=0.0){				
				results.put(match.getRecordTableName()+":"+match.getRecordKey(), match);				
			}
		}

		return results;
	}

	
	public void addMessages(String string, String string2, String string3, String string4, boolean b);

	public MatchRecordInterface calculateScore(RecordInterface base, RecordInterface comparitor, boolean forSearch,
		boolean googleSearch, boolean asContent, boolean matchScoring) throws Exception;


	public RecordInterface standardise(RecordInterface base);


	public void setDb(IDBContainer db);

	/**
	 * @param t
	 */
	void setThreads(int t);

	/**
	 * @param cs
	 */
	void setCommitSize(int cs);

	/**
	 * @param nodeName
	 */
	void setNodeName(String nodeName);



}