/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.match;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import com.entitystream.monster.db.Document;
import com.entitystream.identiza.db.IDBContainer;
import com.entitystream.identiza.db.INode;
import com.entitystream.identiza.db.INode;
import com.entitystream.identiza.entity.resolve.metadata.IPurpose;
import com.entitystream.identiza.entity.resolve.metadata.IRule;
import com.entitystream.identiza.entity.resolve.metadata.ITable;
import com.entitystream.identiza.entity.resolve.metadata.ITableColumn;
import com.entitystream.identiza.entity.resolve.metadata.Purpose;
import com.entitystream.identiza.entity.resolve.metadata.Rule;
import com.entitystream.identiza.entity.resolve.metadata.TableColumn;
import com.entitystream.identiza.entity.resolve.processing.Candidate;
import com.entitystream.identiza.entity.resolve.storage.Record;
import com.entitystream.identiza.entity.resolve.storage.RecordInterface;
import com.entitystream.identiza.entity.resolve.storage.RecordInterface;
import com.entitystream.identiza.entity.resolve.storage.Result;

public interface MatchTableInterface {

	boolean isHistory();

	List<IPurpose> getPurposesForTable();

	RecordInterface getRecord(String id);

	String getTableName();

	void setTableName(String tableName);

	

	RecordInterface getRecord(String tableNameOpt, String pkey);

	
	
	String getKeyField();

	
	RecordInterface newRecord(String pkey) throws Exception;

	ArrayList<String> getFields();


	IDBContainer getDB() throws Exception;


	List<String> getLabelFields();


	ITable getMetaTable();


	List<IRule> getRules();

	ConcurrentHashMap<String, Object> getDefaults();

	
	ArrayList<ITableColumn> getIndexColumns();

	ArrayList<Result> getMergedRecords() throws Exception;

	List<String> getTags();

	

	Collection<String> getSequenceColumns();


	List<TableColumn> getColumns();

	String getIconField();

	String getDefaultIcon();

	String getEIDField();

	String getSystemField();

	void initialise(String tablename, MatchSchemaInterface msc) throws Exception;


	boolean hasRecord(String pkey) throws Exception;

	
	RecordInterface putRecord(RecordInterface rec, boolean keyChanged, boolean updateMergeCount, String username) throws Exception;

	

	String getSensitivityField();



	
	boolean isInternal();

	String getLastUpdatedCol();

	void initialise(ITable table, MatchSchemaInterface msc) throws Exception;

	Collection<MatchTableInterface> getTargetTables() throws Exception;

	
	RecordInterface getRecord(INode node) throws Exception;

	void setRules(ArrayList<IRule> rules);

	
	




}
