/**
 *
	MonsterDB - Collection Based Database with fuzzy matching
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.metadata;

import java.util.Collection;
import java.util.List;

import com.entitystream.identiza.entity.resolve.storage.RecordInterface;

/**
 * @author roberthaynes
 *
 */
public interface IPurpose {

    ISchemaMeta getSchDoc();

    double calculateScore(RecordInterface basein, RecordInterface comparitorin, boolean forSearch, boolean asContent,
	    boolean matchScoring) throws Exception;

    RecordInterface standardize(RecordInterface basein) throws Exception;

    String getPurposeName();

    void setPurposeName(String purposeName);

    void addPurposeColumn(PurposeColumn pc);

    List<PurposeColumn> getPurposeColumns();

    void setPurposeColumns(List<PurposeColumn> pc);

    int getTargetAlgo();

    void setTargetAlgo(int algo);

    String getPurposeType();

    void setPurposeType(String purposeType);

    void convertTargetAlgo(String algo);

    Collection<String> getTableColumns(String tableName);

    void setSchemaName(String schemaName);

    String getSchemaName();

    void deletePurposeColumn(String purposeColumnName);

    void setSchDoc(SchemaMeta schemaMeta);

}