/**
 *
	MonsterDB - Collection Based Database with fuzzy matching
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.metadata;

import java.util.ArrayList;

import com.google.gson.JsonObject;

/**
 * @author roberthaynes
 *
 */
public interface IRule {

    String getAction();

    boolean isActive();

    void setActive(boolean active);

    void setAction(String action);

    String getActionText();

    void setActionText(String actionText);

    //public String getTableName() {
    //	return tableName;
    //}
    //public void setTableName(String tableName) {
    //	this.tableName = tableName;
    //}
    int getOrder();

    void setOrder(int order);

    ArrayList<RulePurpose> getRulePurpose();

    void setRulePurpose(ArrayList<RulePurpose> rulePurpose);

    double getHighScore();

    double getLowScore();

    void setLowScore(Double double1);

    void setHighScore(Double double1);

    int getSystemMatchType();

    void convertSystemMatchType(String systemMatchType);

    void setSystemMatchType(int smt);

    boolean isMatchSameSystem();

    void setMatchSameSystem(boolean b);

    String getHashKey();

    JsonObject toJSON();

}