/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.metadata;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.entitystream.monster.db.Document;
import com.entitystream.identiza.entity.resolve.types.MatchProcDefinition;
import com.entitystream.identiza.entity.resolve.types.MatchProcDefinitionInterface;

public interface ISchemaMeta {

	Document toDocument();

	int getCommitSize();

	Collection<ITable> getTables();

	ITable getTable(String tablename);

	List<IPurpose> getPurposes();

	List<IRule> getRules(String tableName);

	List<IIndex> getIndexes();

	String getDBStore();

	String getDefaultDBAddress();

	int getCacheSize();

	List<TableColumn> getColumns(String tableName);

	void updatePurpose(IPurpose p);

	void addPurpose(IPurpose purpose);

	void addPurposeColumn(PurposeColumn pc);


	Document findConcepts(String concept);

	Document findConceptsForProcType(String procType);

	IPurpose getPurpose(String purposeName);

	int getThreads();

	TableColumn getColumn(String tablename, String columnName);

	void addIndex(IIndex index);

	IIndex getIndex(String indexname);

	void addRule(IRule iRule);

	Collection<MatchProcDefinitionInterface> getMatchProcs(String domainName, String instance, String groupName);

	Map<String, Document> getMatchTypes();

	void addMatchTypes(Document mt);

	void clearPurposeColumnMaps(String purposeName);

	void addPurposeColumnMap(PurposeColumnMap pcm);

	List<PurposeColumn> getPurposeColumns(String purposeName, String tableName);

	void deleteColumn(ITableColumn col);

	String getName();

	void deletePurpose(String id);

	void deletePurposeColumn(String purposeName, String purposeColumnName);

	void deleteTable(String tablename);

	void clearRules();

	void clearIndexes();

	List<IPurpose> getPurposes(String tableName);

	List<PurposeColumnMap> getTablePurposeColumnMaps(String tableName);

	List<ITable> getTargetTables();

	
	 List<PurposeColumnMap> getPurposeColumnMaps(String purposeName, String column, String tableName);

	List<PurposeColumnMap> getPurposeColumnMaps(PurposeColumn pc);

	List<String> getTableColumnMaps(String purposeName, String tableName);

	List<PurposeColumnMap> getPurposeColumnMaps(String optPurposeName);

	void deletePurposeColumnMap(PurposeColumnMap object);

	

	void deleteMatchRule(long order);

	void deleteIndex(String def);

	
	void addTable(ITable table);

	
	void addColumn(TableColumn column);

	
	boolean isAutoMatch();

	
	void setAutoMatch(boolean autoM);

}