
/**
 *
	Identiza - Fuzzy matching Libraries
    
    Copyright (C) 2019  Robert James Haynes (EntityStream KFT), Budapest Hungary

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see https://www.gnu.org/licenses/agpl-3.0.en.html
 */
package com.entitystream.identiza.entity.resolve.metadata;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import com.entitystream.monster.db.Document;

/**
 * @author roberthaynes
 *
 */
public interface ITable {

    void init();

    void setTableName(String tableName);

    String getTableName();

    TableColumn getColumn(String colname);

    void setMaxProb(double val);

    String getSensitivityField();

    String getSystemField();

    String getKeyField();

    List<TableColumn> getColumns();

    void setColumns(List<TableColumn> cols);

    void setCandThreshold(int lowThreshold);

    int getCandThreshold();

    void setUseInPaths(boolean boolean1);

    Boolean getUseInPaths();

    int getKeyThreshold();

    void setKeyThreshold(int val);

    double getMaxProb();

    boolean isDocument();

    void setDocument(boolean isDoc);

    boolean isHistory();

    void setHistory(boolean ish);

    List<String> getTags();

    void setTags(List<String> tagsin);

    void setIcon(String iconName);

    String getIcon();

    ConcurrentHashMap<String, Object> createDefaults();

    List<String> findLabelFields();

    void removeColumn(String name);

    boolean isInternal();

    void setInternal(boolean intFlag);

    String getDateFormat();

    DateTimeFormatter createDateFormatter();

    void setDateFormat(String dateFormat);

    void setTableDisplayName(String string);

    String getTableDisplayName();

    String getLastUpdatedCol();

    String getBaseType();

    void setBaseType(String baseType);

    ArrayList<String> getSequenceFields();

    String getSchemaName();

    void setSchemaName(String schemaName);

    String getTransmitFormat();

    void setTransmitFormat(String tmf);

    String getTransmitDestination();

    void setTransmitDestination(String td);

    boolean isTarget();

    void setTarget(boolean ist);

    String getTargetAuthToken();

    void setTargetAuthToken(String targetAuthToken);

    boolean isRelTable();

    void setRelTable(boolean tf);

    void setRestrictedRelationships(boolean set);

    boolean getRestrictedRelationships();

    String getEIDField();

    void addColumn(TableColumn col);

    List<String> getLabelFields();
  
    Document toDocument();

}